/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import io.zeebe.journal.JournalReader;
import io.zeebe.journal.JournalRecord;
import io.zeebe.journal.file.JournalIndex;
import io.zeebe.journal.file.JournalSegment;
import io.zeebe.journal.file.MappedJournalSegmentReader;
import io.zeebe.journal.file.SegmentedJournal;
import java.util.NoSuchElementException;

class SegmentedJournalReader
implements JournalReader {
    private final SegmentedJournal journal;
    private JournalSegment currentSegment;
    private JournalRecord previousEntry;
    private MappedJournalSegmentReader currentReader;

    SegmentedJournalReader(SegmentedJournal journal) {
        this.journal = journal;
        this.initialize();
    }

    private void initialize() {
        this.currentSegment = this.journal.getFirstSegment();
        this.currentReader = this.currentSegment.createReader();
    }

    public long getCurrentIndex() {
        long currentIndex = this.currentReader.getCurrentIndex();
        if (currentIndex != 0L) {
            return currentIndex;
        }
        if (this.previousEntry != null) {
            return this.previousEntry.index();
        }
        return 0L;
    }

    public JournalRecord getCurrentEntry() {
        JournalRecord currentEntry = this.currentReader.getCurrentEntry();
        if (currentEntry != null) {
            return currentEntry;
        }
        return this.previousEntry;
    }

    public long getNextIndex() {
        return this.currentReader.getNextIndex();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextEntry();
    }

    @Override
    public JournalRecord next() {
        if (!this.currentReader.hasNext()) {
            JournalSegment nextSegment = this.journal.getNextSegment(this.currentSegment.index());
            if (nextSegment != null && nextSegment.index() == this.getNextIndex()) {
                this.previousEntry = this.currentReader.getCurrentEntry();
                this.replaceCurrentSegment(nextSegment);
                return this.currentReader.next();
            }
            throw new NoSuchElementException();
        }
        this.previousEntry = this.currentReader.getCurrentEntry();
        return this.currentReader.next();
    }

    @Override
    public long seek(long index) {
        if (!this.currentSegment.isOpen()) {
            this.seekToFirst();
        }
        if (index < this.currentReader.getNextIndex()) {
            this.rewind(index);
        } else if (index > this.currentReader.getNextIndex()) {
            this.forward(index);
        } else {
            this.currentReader.seek(index);
        }
        return this.getNextIndex();
    }

    @Override
    public long seekToFirst() {
        this.replaceCurrentSegment(this.journal.getFirstSegment());
        this.previousEntry = null;
        return this.journal.getFirstIndex();
    }

    @Override
    public long seekToLast() {
        this.replaceCurrentSegment(this.journal.getLastSegment());
        this.seek(this.journal.getLastIndex());
        return this.journal.getLastIndex();
    }

    @Override
    public long seekToAsqn(long asqn) {
        JournalIndex journalIndex = this.journal.getJournalIndex();
        Long index = journalIndex.lookupAsqn(asqn);
        if (index == null) {
            this.seekToFirst();
        } else {
            this.seek(index);
        }
        JournalRecord record = null;
        while (this.hasNext()) {
            JournalRecord currentRecord = this.next();
            if (currentRecord.asqn() <= asqn && currentRecord.asqn() != -1L) {
                record = currentRecord;
                continue;
            }
            if (currentRecord.asqn() < asqn) continue;
            break;
        }
        if (record == null) {
            return this.seekToFirst();
        }
        return this.seek(record.index());
    }

    @Override
    public void close() {
        this.currentReader.close();
        this.journal.closeReader(this);
    }

    private void rewind(long index) {
        long lookupIndex;
        JournalSegment segment;
        if (this.currentSegment.index() >= index && (segment = this.journal.getSegment(lookupIndex = index == Long.MIN_VALUE ? index : index - 1L)) != null) {
            this.replaceCurrentSegment(segment);
        }
        this.currentReader.seek(index);
        this.previousEntry = this.currentReader.getCurrentEntry();
    }

    private void forward(long index) {
        JournalSegment segment;
        if (!this.currentSegment.equals(this.journal.getLastSegment()) && (segment = this.journal.getSegment(index)) != null && !segment.equals(this.currentSegment)) {
            this.replaceCurrentSegment(segment);
        }
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
    }

    private boolean hasNextEntry() {
        if (!this.currentReader.hasNext()) {
            JournalSegment nextSegment = this.journal.getNextSegment(this.currentSegment.index());
            if (nextSegment != null && nextSegment.index() == this.getNextIndex()) {
                this.previousEntry = this.currentReader.getCurrentEntry();
                this.replaceCurrentSegment(nextSegment);
                return this.currentReader.hasNext();
            }
            return false;
        }
        return true;
    }

    private void replaceCurrentSegment(JournalSegment nextSegment) {
        if (this.currentSegment.equals(nextSegment)) {
            this.currentReader.reset();
            return;
        }
        this.currentReader.close();
        this.currentSegment = nextSegment;
        this.currentReader = this.currentSegment.createReader();
    }
}

