/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file;

import io.zeebe.journal.JournalRecord;
import io.zeebe.journal.file.IndexInfo;
import io.zeebe.journal.file.JournalIndex;
import java.util.Map;
import java.util.TreeMap;

class SparseJournalIndex
implements JournalIndex {
    private final int density;
    private final TreeMap<Long, Integer> indexToPosition = new TreeMap();
    private final TreeMap<Long, Long> asqnToIndex = new TreeMap();
    private final TreeMap<Long, Long> indexToAsqn = new TreeMap();

    public SparseJournalIndex(int density) {
        this.density = density;
    }

    @Override
    public void index(JournalRecord indexedEntry, int position) {
        long index = indexedEntry.index();
        if (index % (long)this.density == 0L) {
            this.indexToPosition.put(index, position);
            long asqn = indexedEntry.asqn();
            if (asqn != -1L) {
                this.asqnToIndex.put(asqn, index);
                this.indexToAsqn.put(index, asqn);
            }
        }
    }

    @Override
    public IndexInfo lookup(long index) {
        Map.Entry<Long, Integer> entry = this.indexToPosition.floorEntry(index);
        return entry != null ? new IndexInfo(entry.getKey(), entry.getValue()) : null;
    }

    @Override
    public Long lookupAsqn(long asqn) {
        Map.Entry<Long, Long> entry = this.asqnToIndex.floorEntry(asqn);
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public void deleteAfter(long index) {
        this.indexToPosition.tailMap(index, false).clear();
        Map.Entry<Long, Long> asqnEntryToDelete = this.indexToAsqn.ceilingEntry(index);
        if (asqnEntryToDelete != null) {
            Long asqnToDelete = asqnEntryToDelete.getValue();
            this.indexToAsqn.tailMap(index, false).clear();
            boolean include = asqnEntryToDelete.getKey() > index;
            this.asqnToIndex.tailMap(asqnToDelete, include).clear();
        }
    }

    @Override
    public void deleteUntil(long index) {
        this.indexToPosition.headMap(index, false).clear();
        Map.Entry<Long, Long> asqnEntryToDelete = this.indexToAsqn.floorEntry(index);
        if (asqnEntryToDelete != null) {
            Long asqnToDelete = asqnEntryToDelete.getValue();
            this.indexToAsqn.headMap(index, false).clear();
            this.asqnToIndex.headMap(asqnToDelete, false).clear();
        }
    }

    @Override
    public void clear() {
        this.indexToPosition.clear();
        this.indexToAsqn.clear();
        this.asqnToIndex.clear();
    }
}

