/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.journal.file.record;

import io.zeebe.journal.JournalRecord;
import io.zeebe.journal.StorageException;
import io.zeebe.journal.file.ChecksumGenerator;
import io.zeebe.journal.file.record.JournalRecordSerializer;
import io.zeebe.journal.file.record.PersistedJournalRecord;
import io.zeebe.journal.file.record.RecordData;
import io.zeebe.journal.file.record.RecordMetadata;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JournalRecordReaderUtil {
    private final JournalRecordSerializer serializer;
    private final ChecksumGenerator checksumGenerator = new ChecksumGenerator();

    public JournalRecordReaderUtil(JournalRecordSerializer serializer) {
        this.serializer = serializer;
    }

    public JournalRecord read(ByteBuffer buffer, long expectedIndex) {
        buffer.mark();
        if (buffer.position() + this.serializer.getMetadataLength() > buffer.limit()) {
            return null;
        }
        int startPosition = buffer.position();
        try {
            UnsafeBuffer directBuffer = new UnsafeBuffer(buffer.slice());
            if (!this.serializer.hasMetadata((DirectBuffer)directBuffer, 0)) {
                return null;
            }
            RecordMetadata metadata = this.serializer.readMetadata((DirectBuffer)directBuffer, 0);
            int metadataLength = this.serializer.getMetadataLength((DirectBuffer)directBuffer, 0);
            int recordLength = metadata.length();
            if (buffer.position() + metadataLength + recordLength > buffer.limit()) {
                return null;
            }
            long checksum = this.checksumGenerator.compute(buffer, startPosition + metadataLength, recordLength);
            if (checksum != metadata.checksum()) {
                buffer.reset();
                return null;
            }
            RecordData record = this.serializer.readData((DirectBuffer)directBuffer, metadataLength, recordLength);
            if (record != null && expectedIndex != record.index()) {
                buffer.reset();
                throw new StorageException.InvalidIndex(String.format("Expected to read a record with next index %d, but found %d", expectedIndex, record.index()));
            }
            buffer.position(startPosition + metadataLength + recordLength);
            return new PersistedJournalRecord(metadata, record);
        }
        catch (BufferUnderflowException e) {
            buffer.reset();
            return null;
        }
    }
}

