/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter.proto;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedInputValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedOutputValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MatchedRuleValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.protocol.record.value.management.CheckpointRecordValue;
import io.zeebe.exporter.proto.Schema;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class RecordTransformer {
    private static final EnumMap<ValueType, Function<Record, GeneratedMessageV3>> TRANSFORMERS = new EnumMap(ValueType.class);
    private static final EnumMap<ValueType, Schema.RecordMetadata.ValueType> VALUE_TYPE_MAPPING = new EnumMap(ValueType.class);
    private static final EnumMap<RecordType, Schema.RecordMetadata.RecordType> RECORD_TYPE_MAPPING = new EnumMap<RecordType, Schema.RecordMetadata.RecordType>(Map.of(RecordType.COMMAND, Schema.RecordMetadata.RecordType.COMMAND, RecordType.COMMAND_REJECTION, Schema.RecordMetadata.RecordType.COMMAND_REJECTION, RecordType.EVENT, Schema.RecordMetadata.RecordType.EVENT));
    private static final EnumMap<VariableDocumentUpdateSemantic, Schema.VariableDocumentRecord.UpdateSemantics> UPDATE_SEMANTICS_MAPPING = new EnumMap<VariableDocumentUpdateSemantic, Schema.VariableDocumentRecord.UpdateSemantics>(Map.of(VariableDocumentUpdateSemantic.LOCAL, Schema.VariableDocumentRecord.UpdateSemantics.LOCAL, VariableDocumentUpdateSemantic.PROPAGATE, Schema.VariableDocumentRecord.UpdateSemantics.PROPAGATE));

    private RecordTransformer() {
    }

    public static GeneratedMessageV3 toProtobufMessage(Record record) {
        ValueType valueType = record.getValueType();
        Function<Record, GeneratedMessageV3> toRecordFunc = TRANSFORMERS.get(valueType);
        return toRecordFunc != null ? toRecordFunc.apply(record) : Empty.getDefaultInstance();
    }

    public static Schema.RecordId toRecordId(Record record) {
        return Schema.RecordId.newBuilder().setPartitionId(record.getPartitionId()).setPosition(record.getPosition()).build();
    }

    public static Schema.Record toGenericRecord(Record record) {
        GeneratedMessageV3 protobufRecord = RecordTransformer.toProtobufMessage(record);
        Any anyRecord = Any.pack((Message)protobufRecord);
        return Schema.Record.newBuilder().setRecord(anyRecord).build();
    }

    private static Schema.RecordMetadata toMetadata(Record record) {
        Schema.RecordMetadata.Builder builder = Schema.RecordMetadata.newBuilder().setIntent(record.getIntent().name()).setValueType(RecordTransformer.toValueType(record.getValueType())).setKey(record.getKey()).setRecordType(RecordTransformer.toRecordType(record.getRecordType())).setSourceRecordPosition(record.getSourceRecordPosition()).setPosition(record.getPosition()).setTimestamp(record.getTimestamp()).setPartitionId(record.getPartitionId());
        if (record.getRejectionType() != null) {
            builder.setRejectionType(record.getRejectionType().name());
            builder.setRejectionReason(record.getRejectionReason());
        }
        return builder.build();
    }

    private static Schema.RecordMetadata.ValueType toValueType(ValueType valueType) {
        return VALUE_TYPE_MAPPING.getOrDefault(valueType, Schema.RecordMetadata.ValueType.UNKNOWN_VALUE_TYPE);
    }

    private static Schema.RecordMetadata.RecordType toRecordType(RecordType recordType) {
        return RECORD_TYPE_MAPPING.getOrDefault(recordType, Schema.RecordMetadata.RecordType.UNKNOWN_RECORD_TYPE);
    }

    private static Schema.DeploymentRecord toDeploymentRecord(Record<DeploymentRecordValue> record) {
        Schema.DeploymentRecord.Builder builder = Schema.DeploymentRecord.newBuilder().setMetadata(RecordTransformer.toMetadata(record));
        for (DeploymentResource resource : ((DeploymentRecordValue)record.getValue()).getResources()) {
            builder.addResources(RecordTransformer.toDeploymentRecordResource(resource));
        }
        for (ProcessMetadataValue processMetadata : ((DeploymentRecordValue)record.getValue()).getProcessesMetadata()) {
            builder.addProcessMetadata(RecordTransformer.toProcessMetadata(processMetadata));
        }
        for (DecisionRequirementsMetadataValue decisionRequirementsMetadata : ((DeploymentRecordValue)record.getValue()).getDecisionRequirementsMetadata()) {
            builder.addDecisionRequirementsMetadata(RecordTransformer.toDecisionRequirementsMetadata(decisionRequirementsMetadata));
        }
        for (DecisionRecordValue decisionMetadata : ((DeploymentRecordValue)record.getValue()).getDecisionsMetadata()) {
            builder.addDecisionMetadata(RecordTransformer.toDecisionMetadata(decisionMetadata));
        }
        return builder.build();
    }

    private static Schema.DeploymentRecord.Resource toDeploymentRecordResource(DeploymentResource resource) {
        return Schema.DeploymentRecord.Resource.newBuilder().setResource(ByteString.copyFrom((byte[])resource.getResource())).setResourceName(resource.getResourceName()).build();
    }

    private static Schema.DeploymentRecord.ProcessMetadata toProcessMetadata(ProcessMetadataValue processMetadata) {
        return Schema.DeploymentRecord.ProcessMetadata.newBuilder().setBpmnProcessId(processMetadata.getBpmnProcessId()).setResourceName(processMetadata.getResourceName()).setVersion(processMetadata.getVersion()).setProcessDefinitionKey(processMetadata.getProcessDefinitionKey()).setChecksum(ByteString.copyFrom((byte[])processMetadata.getChecksum())).build();
    }

    private static Schema.DeploymentRecord.DecisionMetadata toDecisionMetadata(DecisionRecordValue decision) {
        return Schema.DeploymentRecord.DecisionMetadata.newBuilder().setDecisionId(decision.getDecisionId()).setDecisionKey(decision.getDecisionKey()).setVersion(decision.getVersion()).setDecisionName(decision.getDecisionName()).setDecisionRequirementsId(decision.getDecisionRequirementsId()).setDecisionRequirementsKey(decision.getDecisionRequirementsKey()).setIsDuplicate(decision.isDuplicate()).build();
    }

    private static Schema.DeploymentDistributionRecord toDeploymentDistributionRecord(Record<DeploymentDistributionRecordValue> record) {
        return Schema.DeploymentDistributionRecord.newBuilder().setPartitionId(((DeploymentDistributionRecordValue)record.getValue()).getPartitionId()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.ProcessRecord toProcessRecord(Record<Process> record) {
        Process value = (Process)record.getValue();
        return Schema.ProcessRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setResourceName(value.getResourceName()).setResource(ByteString.copyFrom((byte[])value.getResource())).setVersion(value.getVersion()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setChecksum(ByteString.copyFrom((byte[])value.getChecksum())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.IncidentRecord toIncidentRecord(Record<IncidentRecordValue> record) {
        IncidentRecordValue value = (IncidentRecordValue)record.getValue();
        return Schema.IncidentRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setElementInstanceKey(value.getElementInstanceKey()).setErrorMessage(value.getErrorMessage()).setErrorType(value.getErrorType().name()).setJobKey(value.getJobKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setVariableScopeKey(value.getVariableScopeKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.JobRecord toJobRecord(Record<JobRecordValue> record) {
        Schema.JobRecord.Builder builder = RecordTransformer.toJobRecord((JobRecordValue)record.getValue());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.JobRecord.Builder toJobRecord(JobRecordValue value) {
        return Schema.JobRecord.newBuilder().setDeadline(value.getDeadline()).setErrorMessage(value.getErrorMessage()).setRetries(value.getRetries()).setType(value.getType()).setWorker(value.getWorker()).setVariables(RecordTransformer.toStruct(value.getVariables())).setCustomHeaders(RecordTransformer.toStruct(value.getCustomHeaders())).setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setElementInstanceKey(value.getElementInstanceKey()).setWorkflowDefinitionVersion(value.getProcessDefinitionVersion()).setProcessInstanceKey(value.getProcessInstanceKey()).setProcessDefinitionKey(value.getProcessDefinitionKey());
    }

    private static Schema.JobBatchRecord toJobBatchRecord(Record<JobBatchRecordValue> record) {
        JobBatchRecordValue value = (JobBatchRecordValue)record.getValue();
        Schema.JobBatchRecord.Builder builder = Schema.JobBatchRecord.newBuilder();
        if (!value.getJobs().isEmpty()) {
            for (JobRecordValue job : value.getJobs()) {
                builder.addJobs(RecordTransformer.toJobRecord(job));
            }
        }
        if (!value.getJobKeys().isEmpty()) {
            builder.addAllJobKeys(value.getJobKeys());
        }
        return builder.setMaxJobsToActivate(value.getMaxJobsToActivate()).setTimeout(value.getTimeout()).setType(value.getType()).setWorker(value.getWorker()).setTruncated(value.isTruncated()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.MessageRecord toMessageRecord(Record<MessageRecordValue> record) {
        MessageRecordValue value = (MessageRecordValue)record.getValue();
        return Schema.MessageRecord.newBuilder().setCorrelationKey(value.getCorrelationKey()).setMessageId(value.getMessageId()).setName(value.getName()).setTimeToLive(value.getTimeToLive()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.MessageSubscriptionRecord toMessageSubscriptionRecord(Record<MessageSubscriptionRecordValue> record) {
        MessageSubscriptionRecordValue value = (MessageSubscriptionRecordValue)record.getValue();
        return Schema.MessageSubscriptionRecord.newBuilder().setCorrelationKey(value.getCorrelationKey()).setElementInstanceKey(value.getElementInstanceKey()).setMessageName(value.getMessageName()).setProcessInstanceKey(value.getProcessInstanceKey()).setBpmnProcessId(value.getBpmnProcessId()).setMessageKey(value.getMessageKey()).setVariables(RecordTransformer.toStruct(value.getVariables())).setIsInterrupting(value.isInterrupting()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.MessageStartEventSubscriptionRecord toMessageStartEventSubscriptionRecord(Record<MessageStartEventSubscriptionRecordValue> record) {
        MessageStartEventSubscriptionRecordValue value = (MessageStartEventSubscriptionRecordValue)record.getValue();
        Schema.MessageStartEventSubscriptionRecord.Builder builder = Schema.MessageStartEventSubscriptionRecord.newBuilder();
        builder.setProcessDefinitionKey(value.getProcessDefinitionKey()).setMessageName(value.getMessageName()).setStartEventId(value.getStartEventId()).setBpmnProcessId(value.getBpmnProcessId()).setCorrelationKey(value.getCorrelationKey()).setMessageKey(value.getMessageKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setVariables(RecordTransformer.toStruct(value.getVariables()));
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.VariableRecord toVariableRecord(Record<VariableRecordValue> record) {
        VariableRecordValue value = (VariableRecordValue)record.getValue();
        Schema.VariableRecord.Builder builder = Schema.VariableRecord.newBuilder();
        builder.setScopeKey(value.getScopeKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setBpmnProcessId(value.getBpmnProcessId()).setName(value.getName()).setValue(value.getValue());
        return builder.setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.TimerRecord toTimerRecord(Record<TimerRecordValue> record) {
        TimerRecordValue value = (TimerRecordValue)record.getValue();
        return Schema.TimerRecord.newBuilder().setDueDate(value.getDueDate()).setRepetitions(value.getRepetitions()).setElementInstanceKey(value.getElementInstanceKey()).setTargetElementId(value.getTargetElementId()).setProcessInstanceKey(value.getProcessInstanceKey()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.ProcessInstanceRecord toProcessInstanceRecord(Record<ProcessInstanceRecordValue> record) {
        ProcessInstanceRecordValue value = (ProcessInstanceRecordValue)record.getValue();
        return Schema.ProcessInstanceRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setElementId(value.getElementId()).setFlowScopeKey(value.getFlowScopeKey()).setVersion(value.getVersion()).setProcessInstanceKey(value.getProcessInstanceKey()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setBpmnElementType(value.getBpmnElementType().name()).setBpmnEventType(value.getBpmnEventType().name()).setParentProcessInstanceKey(value.getParentProcessInstanceKey()).setParentElementInstanceKey(value.getParentElementInstanceKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.ProcessMessageSubscriptionRecord toProcessMessageSubscriptionRecord(Record<ProcessMessageSubscriptionRecordValue> record) {
        ProcessMessageSubscriptionRecordValue value = (ProcessMessageSubscriptionRecordValue)record.getValue();
        return Schema.ProcessMessageSubscriptionRecord.newBuilder().setElementInstanceKey(value.getElementInstanceKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setMessageName(value.getMessageName()).setVariables(RecordTransformer.toStruct(value.getVariables())).setBpmnProcessId(value.getBpmnProcessId()).setMessageKey(value.getMessageKey()).setCorrelationKey(value.getCorrelationKey()).setElementId(value.getElementId()).setIsInterrupting(value.isInterrupting()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.ProcessInstanceCreationRecord toProcessInstanceCreationRecord(Record<ProcessInstanceCreationRecordValue> record) {
        ProcessInstanceCreationRecordValue value = (ProcessInstanceCreationRecordValue)record.getValue();
        return Schema.ProcessInstanceCreationRecord.newBuilder().setBpmnProcessId(value.getBpmnProcessId()).setVersion(value.getVersion()).setProcessInstanceKey(value.getProcessInstanceKey()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.VariableDocumentRecord toVariableDocumentRecord(Record<VariableDocumentRecordValue> record) {
        VariableDocumentRecordValue value = (VariableDocumentRecordValue)record.getValue();
        return Schema.VariableDocumentRecord.newBuilder().setScopeKey(value.getScopeKey()).setUpdateSemantics(RecordTransformer.toUpdateSemantics(value.getUpdateSemantics())).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.VariableDocumentRecord.UpdateSemantics toUpdateSemantics(VariableDocumentUpdateSemantic updateSemantics) {
        return UPDATE_SEMANTICS_MAPPING.getOrDefault(updateSemantics, Schema.VariableDocumentRecord.UpdateSemantics.UNKNOWN_UPDATE_SEMANTICS);
    }

    private static Schema.ErrorRecord toErrorRecord(Record<ErrorRecordValue> record) {
        ErrorRecordValue value = (ErrorRecordValue)record.getValue();
        return Schema.ErrorRecord.newBuilder().setExceptionMessage(value.getExceptionMessage()).setStacktrace(value.getStacktrace()).setErrorEventPosition(value.getErrorEventPosition()).setProcessInstanceKey(value.getProcessInstanceKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.ProcessEventRecord toProcessEventRecord(Record<ProcessEventRecordValue> record) {
        ProcessEventRecordValue value = (ProcessEventRecordValue)record.getValue();
        return Schema.ProcessEventRecord.newBuilder().setProcessDefinitionKey(value.getProcessDefinitionKey()).setScopeKey(value.getScopeKey()).setTargetElementId(value.getTargetElementId()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.DecisionRecord toDecisionRecord(Record<DecisionRecordValue> record) {
        DecisionRecordValue value = (DecisionRecordValue)record.getValue();
        return Schema.DecisionRecord.newBuilder().setDecisionId(value.getDecisionId()).setDecisionKey(value.getDecisionKey()).setVersion(value.getVersion()).setDecisionName(value.getDecisionName()).setDecisionRequirementsId(value.getDecisionRequirementsId()).setDecisionRequirementsKey(value.getDecisionRequirementsKey()).setIsDuplicate(value.isDuplicate()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.DecisionRequirementsRecord toDecisionRequirementsRecord(Record<DecisionRequirementsRecordValue> record) {
        DecisionRequirementsRecordValue value = (DecisionRequirementsRecordValue)record.getValue();
        return Schema.DecisionRequirementsRecord.newBuilder().setResource(ByteString.copyFrom((byte[])value.getResource())).setDecisionRequirementsMetadata(RecordTransformer.toDecisionRequirementsMetadata((DecisionRequirementsMetadataValue)value)).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.DecisionRequirementsMetadata toDecisionRequirementsMetadata(DecisionRequirementsMetadataValue metadataValue) {
        return Schema.DecisionRequirementsMetadata.newBuilder().setDecisionRequirementsId(metadataValue.getDecisionRequirementsId()).setDecisionRequirementsName(metadataValue.getDecisionRequirementsName()).setDecisionRequirementsVersion(metadataValue.getDecisionRequirementsVersion()).setDecisionRequirementsKey(metadataValue.getDecisionRequirementsKey()).setNamespace(metadataValue.getNamespace()).setResourceName(metadataValue.getResourceName()).setChecksum(ByteString.copyFrom((byte[])metadataValue.getChecksum())).setIsDuplicate(metadataValue.isDuplicate()).build();
    }

    private static Schema.DecisionEvaluationRecord toDecisionEvaluationRecord(Record<DecisionEvaluationRecordValue> record) {
        DecisionEvaluationRecordValue value = (DecisionEvaluationRecordValue)record.getValue();
        Schema.DecisionEvaluationRecord.Builder builder = Schema.DecisionEvaluationRecord.newBuilder();
        if (!value.getEvaluatedDecisions().isEmpty()) {
            for (EvaluatedDecisionValue item : value.getEvaluatedDecisions()) {
                builder.addEvaluatedDecisions(RecordTransformer.toEvaluatedDecision(item));
            }
        }
        return builder.setDecisionKey(value.getDecisionKey()).setDecisionId(value.getDecisionId()).setDecisionName(value.getDecisionName()).setDecisionVersion(value.getDecisionVersion()).setDecisionRequirementsId(value.getDecisionRequirementsId()).setDecisionRequirementsKey(value.getDecisionRequirementsKey()).setDecisionOutput(value.getDecisionOutput()).setBpmnProcessId(value.getBpmnProcessId()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setElementId(value.getElementId()).setElementInstanceKey(value.getElementInstanceKey()).setEvaluationFailureMessage(value.getEvaluationFailureMessage()).setFailedDecisionId(value.getFailedDecisionId()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.DecisionEvaluationRecord.EvaluatedDecision toEvaluatedDecision(EvaluatedDecisionValue value) {
        Schema.DecisionEvaluationRecord.EvaluatedDecision.Builder builder = Schema.DecisionEvaluationRecord.EvaluatedDecision.newBuilder();
        if (!value.getEvaluatedInputs().isEmpty()) {
            for (EvaluatedInputValue item : value.getEvaluatedInputs()) {
                builder.addEvaluatedInputs(RecordTransformer.toEvaluatedInput(item));
            }
        }
        if (!value.getMatchedRules().isEmpty()) {
            for (EvaluatedInputValue item : value.getMatchedRules()) {
                builder.addMatchedRules(RecordTransformer.toMatchedRule((MatchedRuleValue)item));
            }
        }
        return builder.setDecisionId(value.getDecisionId()).setDecisionName(value.getDecisionName()).setDecisionKey(value.getDecisionKey()).setDecisionVersion(value.getDecisionVersion()).setDecisionType(value.getDecisionType()).setDecisionOutput(value.getDecisionOutput()).build();
    }

    private static Schema.DecisionEvaluationRecord.MatchedRule toMatchedRule(MatchedRuleValue value) {
        Schema.DecisionEvaluationRecord.MatchedRule.Builder builder = Schema.DecisionEvaluationRecord.MatchedRule.newBuilder();
        if (!value.getEvaluatedOutputs().isEmpty()) {
            for (EvaluatedOutputValue item : value.getEvaluatedOutputs()) {
                builder.addEvaluatedOutputs(RecordTransformer.toEvaluatedOutput(item));
            }
        }
        return builder.setRuleId(value.getRuleId()).setRuleIndex(value.getRuleIndex()).build();
    }

    private static Schema.DecisionEvaluationRecord.EvaluatedOutput toEvaluatedOutput(EvaluatedOutputValue value) {
        return Schema.DecisionEvaluationRecord.EvaluatedOutput.newBuilder().setOutputId(value.getOutputId()).setOutputName(value.getOutputName()).setOutputValue(value.getOutputValue()).build();
    }

    private static Schema.DecisionEvaluationRecord.EvaluatedInput toEvaluatedInput(EvaluatedInputValue value) {
        return Schema.DecisionEvaluationRecord.EvaluatedInput.newBuilder().setInputId(value.getInputId()).setInputValue(value.getInputValue()).setInputName(value.getInputName()).build();
    }

    private static Schema.ProcessInstanceModificationRecord toProcessInstanceModificationRecord(Record<ProcessInstanceModificationRecordValue> record) {
        ProcessInstanceModificationRecordValue value = (ProcessInstanceModificationRecordValue)record.getValue();
        List activateInstructions = value.getActivateInstructions().stream().map(activateInstruction -> Schema.ProcessInstanceModificationRecord.ProcessInstanceModificationActivateInstruction.newBuilder().setElementId(activateInstruction.getElementId()).setAncestorScopeKey(activateInstruction.getAncestorScopeKey()).addAllAncestorScopeKeys(activateInstruction.getAncestorScopeKeys()).addAllVariableInstructions(activateInstruction.getVariableInstructions().stream().map(variableInstruction -> Schema.ProcessInstanceModificationRecord.ProcessInstanceModificationVariableInstruction.newBuilder().setElementId(variableInstruction.getElementId()).setVariables(RecordTransformer.toStruct(variableInstruction.getVariables())).build()).collect(Collectors.toList())).build()).collect(Collectors.toList());
        List terminateInstructions = value.getTerminateInstructions().stream().map(terminateInstruction -> Schema.ProcessInstanceModificationRecord.ProcessInstanceModificationTerminateInstruction.newBuilder().setElementInstanceKey(terminateInstruction.getElementInstanceKey()).build()).collect(Collectors.toList());
        return Schema.ProcessInstanceModificationRecord.newBuilder().setProcessInstanceKey(value.getProcessInstanceKey()).addAllActivateInstructions(activateInstructions).addAllTerminateInstructions(terminateInstructions).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.CheckpointRecord toCheckpointRecord(Record<CheckpointRecordValue> record) {
        CheckpointRecordValue value = (CheckpointRecordValue)record.getValue();
        return Schema.CheckpointRecord.newBuilder().setId(value.getCheckpointId()).setPosition(value.getCheckpointPosition()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.SignalRecord toSignalRecord(Record<SignalRecordValue> record) {
        SignalRecordValue value = (SignalRecordValue)record.getValue();
        return Schema.SignalRecord.newBuilder().setSignalName(value.getSignalName()).setVariables(RecordTransformer.toStruct(value.getVariables())).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Schema.SignalSubscriptionRecord toSignalSubscriptionRecord(Record<SignalSubscriptionRecordValue> record) {
        SignalSubscriptionRecordValue value = (SignalSubscriptionRecordValue)record.getValue();
        return Schema.SignalSubscriptionRecord.newBuilder().setSignalName(value.getSignalName()).setBpmnProcessId(value.getBpmnProcessId()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setCatchEventId(value.getCatchEventId()).setCatchEventInstanceKey(value.getCatchEventInstanceKey()).setMetadata(RecordTransformer.toMetadata(record)).build();
    }

    private static Struct toStruct(Map<?, ?> map) {
        Struct.Builder builder = Struct.newBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.putFields(entry.getKey().toString(), RecordTransformer.toValue(entry.getValue()));
        }
        return builder.build();
    }

    private static Value toValue(Object object) {
        Value.Builder builder = Value.newBuilder();
        if (object == null) {
            builder.setNullValue(NullValue.NULL_VALUE);
        } else if (object instanceof Number) {
            builder.setNumberValue(((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            builder.setBoolValue(((Boolean)object).booleanValue());
        } else if (object instanceof List) {
            List list = (List)object;
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object item : list) {
                listBuilder.addValues(RecordTransformer.toValue(item));
            }
            builder.setListValue(listBuilder.build());
        } else if (object instanceof Map) {
            builder.setStructValue(RecordTransformer.toStruct((Map)object));
        } else if (object instanceof String) {
            builder.setStringValue((String)object);
        } else {
            throw new IllegalArgumentException(String.format("Unexpected struct value of type %s, should be one of: null, Number, Boolean, List, Map, String", object.getClass().getCanonicalName()));
        }
        return builder.build();
    }

    static {
        TRANSFORMERS.put(ValueType.DEPLOYMENT, RecordTransformer::toDeploymentRecord);
        TRANSFORMERS.put(ValueType.DEPLOYMENT_DISTRIBUTION, RecordTransformer::toDeploymentDistributionRecord);
        TRANSFORMERS.put(ValueType.PROCESS_INSTANCE, RecordTransformer::toProcessInstanceRecord);
        TRANSFORMERS.put(ValueType.JOB_BATCH, RecordTransformer::toJobBatchRecord);
        TRANSFORMERS.put(ValueType.JOB, RecordTransformer::toJobRecord);
        TRANSFORMERS.put(ValueType.INCIDENT, RecordTransformer::toIncidentRecord);
        TRANSFORMERS.put(ValueType.MESSAGE, RecordTransformer::toMessageRecord);
        TRANSFORMERS.put(ValueType.MESSAGE_SUBSCRIPTION, RecordTransformer::toMessageSubscriptionRecord);
        TRANSFORMERS.put(ValueType.PROCESS, RecordTransformer::toProcessRecord);
        TRANSFORMERS.put(ValueType.PROCESS_EVENT, RecordTransformer::toProcessEventRecord);
        TRANSFORMERS.put(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, RecordTransformer::toProcessMessageSubscriptionRecord);
        TRANSFORMERS.put(ValueType.TIMER, RecordTransformer::toTimerRecord);
        TRANSFORMERS.put(ValueType.VARIABLE, RecordTransformer::toVariableRecord);
        TRANSFORMERS.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, RecordTransformer::toMessageStartEventSubscriptionRecord);
        TRANSFORMERS.put(ValueType.PROCESS_INSTANCE_CREATION, RecordTransformer::toProcessInstanceCreationRecord);
        TRANSFORMERS.put(ValueType.VARIABLE_DOCUMENT, RecordTransformer::toVariableDocumentRecord);
        TRANSFORMERS.put(ValueType.ERROR, RecordTransformer::toErrorRecord);
        TRANSFORMERS.put(ValueType.DECISION, RecordTransformer::toDecisionRecord);
        TRANSFORMERS.put(ValueType.DECISION_REQUIREMENTS, RecordTransformer::toDecisionRequirementsRecord);
        TRANSFORMERS.put(ValueType.DECISION_EVALUATION, RecordTransformer::toDecisionEvaluationRecord);
        TRANSFORMERS.put(ValueType.PROCESS_INSTANCE_MODIFICATION, RecordTransformer::toProcessInstanceModificationRecord);
        TRANSFORMERS.put(ValueType.CHECKPOINT, RecordTransformer::toCheckpointRecord);
        TRANSFORMERS.put(ValueType.SIGNAL, RecordTransformer::toSignalRecord);
        TRANSFORMERS.put(ValueType.SIGNAL_SUBSCRIPTION, RecordTransformer::toSignalSubscriptionRecord);
        VALUE_TYPE_MAPPING.put(ValueType.DEPLOYMENT, Schema.RecordMetadata.ValueType.DEPLOYMENT);
        VALUE_TYPE_MAPPING.put(ValueType.DEPLOYMENT_DISTRIBUTION, Schema.RecordMetadata.ValueType.DEPLOYMENT_DISTRIBUTION);
        VALUE_TYPE_MAPPING.put(ValueType.ERROR, Schema.RecordMetadata.ValueType.ERROR);
        VALUE_TYPE_MAPPING.put(ValueType.INCIDENT, Schema.RecordMetadata.ValueType.INCIDENT);
        VALUE_TYPE_MAPPING.put(ValueType.JOB, Schema.RecordMetadata.ValueType.JOB);
        VALUE_TYPE_MAPPING.put(ValueType.JOB_BATCH, Schema.RecordMetadata.ValueType.JOB_BATCH);
        VALUE_TYPE_MAPPING.put(ValueType.MESSAGE, Schema.RecordMetadata.ValueType.MESSAGE);
        VALUE_TYPE_MAPPING.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, Schema.RecordMetadata.ValueType.MESSAGE_START_EVENT_SUBSCRIPTION);
        VALUE_TYPE_MAPPING.put(ValueType.MESSAGE_SUBSCRIPTION, Schema.RecordMetadata.ValueType.MESSAGE_SUBSCRIPTION);
        VALUE_TYPE_MAPPING.put(ValueType.TIMER, Schema.RecordMetadata.ValueType.TIMER);
        VALUE_TYPE_MAPPING.put(ValueType.VARIABLE, Schema.RecordMetadata.ValueType.VARIABLE);
        VALUE_TYPE_MAPPING.put(ValueType.VARIABLE_DOCUMENT, Schema.RecordMetadata.ValueType.VARIABLE_DOCUMENT);
        VALUE_TYPE_MAPPING.put(ValueType.PROCESS, Schema.RecordMetadata.ValueType.PROCESS);
        VALUE_TYPE_MAPPING.put(ValueType.PROCESS_EVENT, Schema.RecordMetadata.ValueType.PROCESS_EVENT);
        VALUE_TYPE_MAPPING.put(ValueType.PROCESS_INSTANCE, Schema.RecordMetadata.ValueType.PROCESS_INSTANCE);
        VALUE_TYPE_MAPPING.put(ValueType.PROCESS_INSTANCE_CREATION, Schema.RecordMetadata.ValueType.PROCESS_INSTANCE_CREATION);
        VALUE_TYPE_MAPPING.put(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, Schema.RecordMetadata.ValueType.PROCESS_MESSAGE_SUBSCRIPTION);
        VALUE_TYPE_MAPPING.put(ValueType.DECISION, Schema.RecordMetadata.ValueType.DECISION);
        VALUE_TYPE_MAPPING.put(ValueType.DECISION_REQUIREMENTS, Schema.RecordMetadata.ValueType.DECISION_REQUIREMENTS);
        VALUE_TYPE_MAPPING.put(ValueType.DECISION_EVALUATION, Schema.RecordMetadata.ValueType.DECISION_EVALUATION);
        VALUE_TYPE_MAPPING.put(ValueType.PROCESS_INSTANCE_MODIFICATION, Schema.RecordMetadata.ValueType.PROCESS_INSTANCE_MODIFICATION);
        VALUE_TYPE_MAPPING.put(ValueType.CHECKPOINT, Schema.RecordMetadata.ValueType.CHECKPOINT);
        VALUE_TYPE_MAPPING.put(ValueType.ESCALATION, Schema.RecordMetadata.ValueType.ESCALATION);
        VALUE_TYPE_MAPPING.put(ValueType.SIGNAL_SUBSCRIPTION, Schema.RecordMetadata.ValueType.SIGNAL_SUBSCRIPTION);
        VALUE_TYPE_MAPPING.put(ValueType.SIGNAL, Schema.RecordMetadata.ValueType.SIGNAL);
        VALUE_TYPE_MAPPING.put(ValueType.RESOURCE_DELETION, Schema.RecordMetadata.ValueType.RESOURCE_DELETION);
        VALUE_TYPE_MAPPING.put(ValueType.COMMAND_DISTRIBUTION, Schema.RecordMetadata.ValueType.COMMAND_DISTRIBUTION);
    }
}

