/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.filter;

import io.zeebe.msgpack.filter.MsgPackFilter;
import io.zeebe.msgpack.query.MsgPackTraversalContext;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackType;
import io.zeebe.msgpack.util.ByteUtil;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MapValueWithKeyFilter
implements MsgPackFilter {
    public static final int NO_MATCHING_VALUE = -1;

    @Override
    public boolean matches(MsgPackTraversalContext ctx, DirectBuffer filterContext, MsgPackToken value) {
        if (ctx.hasElements() && ctx.isMap()) {
            MutableDirectBuffer dynamicContext = ctx.dynamicContext();
            int currentElement = ctx.currentElement();
            if (currentElement == 0) {
                dynamicContext.putInt(0, -1);
            }
            int matchingValueIndex = dynamicContext.getInt(0);
            int queryLength = filterContext.getInt(0);
            if (currentElement == matchingValueIndex) {
                dynamicContext.putInt(0, -1);
                return true;
            }
            if (ctx.currentElement() % 2 == 0 && value.getType() == MsgPackType.STRING && ByteUtil.equal(filterContext, 4, queryLength, value.getValueBuffer(), 0, value.getValueBuffer().capacity())) {
                dynamicContext.putInt(0, currentElement + 1);
            }
        }
        return false;
    }

    public static void encodeDynamicContext(MutableDirectBuffer contextBuffer, DirectBuffer keyBuffer, int keyOffset, int keyLength) {
        contextBuffer.putInt(0, keyLength);
        contextBuffer.putBytes(4, keyBuffer, keyOffset, keyLength);
    }

    public static void encodeDynamicContext(MutableDirectBuffer contextBuffer, String key) {
        UnsafeBuffer keyBuffer = new UnsafeBuffer(key.getBytes(StandardCharsets.UTF_8));
        MapValueWithKeyFilter.encodeDynamicContext(contextBuffer, (DirectBuffer)keyBuffer, 0, keyBuffer.capacity());
    }
}

