/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.jsonpath;

import io.zeebe.msgpack.filter.MsgPackFilter;
import io.zeebe.msgpack.query.MsgPackFilterContext;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JsonPathQuery {
    private static final int MAX_DEPTH = 30;
    private static final int MAX_FILTER_CONTEXT_LENGTH = 50;
    private static final int NO_INVALID_POSITION = -1;
    private final MsgPackFilter[] filters;
    private final MsgPackFilterContext filterInstances = new MsgPackFilterContext(30, 50);
    private final UnsafeBuffer expressionBuffer = new UnsafeBuffer(0L, 0);
    private final DirectBuffer variableName = new UnsafeBuffer(0L, 0);
    private int invalidPosition;
    private String errorMessage;

    public JsonPathQuery(MsgPackFilter[] filters) {
        this.filters = filters;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.filterInstances.clear();
        this.invalidPosition = -1;
        this.expressionBuffer.wrap(buffer, offset, length);
    }

    public MsgPackFilterContext getFilterInstances() {
        return this.filterInstances;
    }

    public MsgPackFilter[] getFilters() {
        return this.filters;
    }

    public void invalidate(int position, String message) {
        this.invalidPosition = position;
        this.errorMessage = message;
    }

    public boolean isValid() {
        return this.invalidPosition == -1;
    }

    public int getInvalidPosition() {
        return this.invalidPosition;
    }

    public String getErrorReason() {
        return this.errorMessage;
    }

    public String toString() {
        return "JsonPathQuery{expression=" + BufferUtil.bufferAsString((DirectBuffer)this.expressionBuffer) + "}";
    }

    public DirectBuffer getExpression() {
        return this.expressionBuffer;
    }

    public DirectBuffer getVariableName() {
        return this.variableName;
    }

    public void setVariableName(byte[] topLevelVariable) {
        this.variableName.wrap(topLevelVariable);
    }
}

