/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.jsonpath;

import io.zeebe.msgpack.filter.ArrayIndexFilter;
import io.zeebe.msgpack.filter.MapValueWithKeyFilter;
import io.zeebe.msgpack.filter.MsgPackFilter;
import io.zeebe.msgpack.filter.RootCollectionFilter;
import io.zeebe.msgpack.filter.WildcardFilter;
import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.jsonpath.JsonPathToken;
import io.zeebe.msgpack.jsonpath.JsonPathTokenVisitor;
import io.zeebe.msgpack.jsonpath.JsonPathTokenizer;
import io.zeebe.msgpack.query.MsgPackFilterContext;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JsonPathQueryCompiler
implements JsonPathTokenVisitor {
    private static final int ROOT_COLLECTION_FILTER_ID = 0;
    private static final int MAP_VALUE_FILTER_ID = 1;
    private static final int ARRAY_INDEX_FILTER_ID = 2;
    private static final int WILDCARD_FILTER_ID = 3;
    private static final MsgPackFilter[] JSON_PATH_FILTERS = new MsgPackFilter[4];
    private final JsonPathTokenizer tokenizer = new JsonPathTokenizer();
    private final UnsafeBuffer expressionBuffer = new UnsafeBuffer(0L, 0);
    private ParsingMode mode;
    private JsonPathQuery currentQuery;

    public JsonPathQuery compile(String jsonPathExpression) {
        this.expressionBuffer.wrap(jsonPathExpression.getBytes(StandardCharsets.UTF_8));
        return this.compile((DirectBuffer)this.expressionBuffer, 0, this.expressionBuffer.capacity());
    }

    public JsonPathQuery compile(DirectBuffer buffer, int offset, int length) {
        this.currentQuery = new JsonPathQuery(JSON_PATH_FILTERS);
        this.currentQuery.wrap(buffer, offset, length);
        this.mode = ParsingMode.LITERAL;
        MsgPackFilterContext filterInstances = this.currentQuery.getFilterInstances();
        filterInstances.appendElement();
        filterInstances.filterId(0);
        this.tokenizer.tokenize(buffer, offset, length, this);
        JsonPathQuery returnValue = this.currentQuery;
        this.currentQuery = null;
        return returnValue;
    }

    @Override
    public void visit(JsonPathToken type, DirectBuffer valueBuffer, int valueOffset, int valueLength) {
        if (!this.currentQuery.isValid()) {
            return;
        }
        if (this.mode == ParsingMode.OPERATOR) {
            switch (type) {
                case CHILD_OPERATOR: {
                    this.mode = ParsingMode.LITERAL;
                    return;
                }
                case START_INPUT: 
                case END_INPUT: {
                    return;
                }
            }
            this.currentQuery.invalidate(valueOffset, "Unexpected json-path token " + type);
        } else if (this.mode == ParsingMode.LITERAL) {
            switch (type) {
                case LITERAL: {
                    MsgPackFilterContext filterInstances = this.currentQuery.getFilterInstances();
                    if (filterInstances.size() == 1) {
                        byte[] variable = new byte[valueLength];
                        valueBuffer.getBytes(valueOffset, variable);
                        this.currentQuery.setVariableName(variable);
                    }
                    filterInstances.appendElement();
                    filterInstances.filterId(1);
                    MapValueWithKeyFilter.encodeDynamicContext(filterInstances.dynamicContext(), valueBuffer, valueOffset, valueLength);
                    this.mode = ParsingMode.OPERATOR;
                    return;
                }
                case START_INPUT: 
                case END_INPUT: {
                    return;
                }
            }
            this.currentQuery.invalidate(valueOffset, "Unexpected json-path token " + type);
        }
    }

    static {
        JsonPathQueryCompiler.JSON_PATH_FILTERS[0] = new RootCollectionFilter();
        JsonPathQueryCompiler.JSON_PATH_FILTERS[1] = new MapValueWithKeyFilter();
        JsonPathQueryCompiler.JSON_PATH_FILTERS[2] = new ArrayIndexFilter();
        JsonPathQueryCompiler.JSON_PATH_FILTERS[3] = new WildcardFilter();
    }

    private static enum ParsingMode {
        OPERATOR,
        LITERAL;

    }
}

