/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.mapping.JsonPathPointer;

public final class Mapping {
    public static final String JSON_ROOT_PATH = "$";
    public static final String MAPPING_STRING = "%s -> %s";
    private final JsonPathQuery source;
    private final JsonPathPointer targetPointer;
    private final Type type;

    public Mapping(JsonPathQuery source, JsonPathPointer targetPointer, Type type) {
        this.source = source;
        this.targetPointer = targetPointer;
        this.type = type;
    }

    public JsonPathQuery getSource() {
        return this.source;
    }

    public JsonPathPointer getTargetPointer() {
        return this.targetPointer;
    }

    public Type getType() {
        return this.type;
    }

    public boolean mapsToRootPath() {
        return this.targetPointer.getPathElements().length == 1;
    }

    public String toString() {
        return String.format(MAPPING_STRING, new String(this.source.getExpression().byteArray()), this.targetPointer);
    }

    public static enum Type {
        PUT,
        COLLECT;

    }
}

