/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.mapping.Mapping;
import io.zeebe.msgpack.mapping.MappingDiff;
import io.zeebe.msgpack.mapping.MappingException;
import io.zeebe.msgpack.mapping.MsgPackDiff;
import io.zeebe.msgpack.query.MsgPackQueryExecutor;
import io.zeebe.msgpack.query.MsgPackTraverser;
import org.agrona.DirectBuffer;

public final class MsgPackDocumentExtractor {
    private static final String EXCEPTION_MSG_MAPPING_DOES_NOT_MATCH = "No data found for query %s.";
    private static final String EXCEPTION_MSG_MAPPING_HAS_MORE_THAN_ONE_MATCHING_SOURCE = "JSON path mapping has more than one matching source.";
    private final MappingDiff diff = new MappingDiff();
    private final MsgPackTraverser traverser = new MsgPackTraverser();
    private final MsgPackQueryExecutor queryExecutor = new MsgPackQueryExecutor();

    public MsgPackDiff extract(DirectBuffer document, boolean strictMode, Mapping ... mappings) {
        this.diff.init(mappings, document);
        this.traverser.wrap(document, 0, document.capacity());
        for (int i = 0; i < mappings.length; ++i) {
            Mapping mapping = mappings[i];
            this.executeLeafMapping(mapping.getSource(), strictMode);
            if (this.queryExecutor.numResults() > 0) {
                if (mapping.mapsToRootPath() && !this.queryExecutor.isCurrentResultAMap(document) && !strictMode) {
                    this.diff.setEmptyMapResult(i);
                    continue;
                }
                this.diff.setResult(i, this.queryExecutor.currentResultPosition(), this.queryExecutor.currentResultLength());
                continue;
            }
            this.diff.setNullResult(i);
        }
        return this.diff;
    }

    private void executeLeafMapping(JsonPathQuery jsonPathQuery, boolean strictMode) {
        this.queryExecutor.init(jsonPathQuery.getFilters(), jsonPathQuery.getFilterInstances());
        this.traverser.reset();
        this.traverser.traverse(this.queryExecutor);
        if (this.queryExecutor.numResults() == 1) {
            this.queryExecutor.moveToResult(0);
        } else if (this.queryExecutor.numResults() == 0) {
            DirectBuffer expression = jsonPathQuery.getExpression();
            if (strictMode) {
                throw new MappingException(String.format(EXCEPTION_MSG_MAPPING_DOES_NOT_MATCH, expression.getStringWithoutLengthUtf8(0, expression.capacity())));
            }
        } else {
            if (strictMode) {
                throw new IllegalStateException(EXCEPTION_MSG_MAPPING_HAS_MORE_THAN_ONE_MATCHING_SOURCE);
            }
            this.queryExecutor.moveToResult(0);
        }
    }
}

