/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.mapping.MsgPackTree;
import io.zeebe.msgpack.query.MsgPackTokenVisitor;
import io.zeebe.msgpack.query.MsgPackTraverser;
import io.zeebe.msgpack.spec.MsgPackToken;
import java.util.ArrayDeque;
import java.util.Deque;
import org.agrona.DirectBuffer;

public final class MsgPackDocumentIndexer
implements MsgPackTokenVisitor {
    private final MsgPackTree msgPackTree;
    private final Deque<TokenParseContext> parsingContextStack = new ArrayDeque<TokenParseContext>();
    private final MapEntryParseContext mapEntryContext = new MapEntryParseContext();
    private final MsgPackTraverser traverser = new MsgPackTraverser();
    private int documentId;

    public MsgPackDocumentIndexer() {
        this.msgPackTree = new MsgPackTree();
    }

    public MsgPackTree index(DirectBuffer document) {
        this.clear();
        if (MsgPackDocumentIndexer.isEmptyOrNil(document)) {
            return this.msgPackTree;
        }
        this.parsingContextStack.push(new TokenParseContext(ParsingMode.MAP_ENTRY, "", 1));
        this.mapEntryContext.currentKey = "$";
        this.mapEntryContext.parsingMode = MapEntryParsingMode.VALUE;
        this.documentId = this.msgPackTree.addDocument(document);
        this.traverser.wrap(document, 0, document.capacity());
        this.traverser.traverse(this);
        return this.msgPackTree;
    }

    private static boolean isEmptyOrNil(DirectBuffer document) {
        return document.capacity() == 0 || -64 == document.getByte(0);
    }

    @Override
    public void visitElement(int position, MsgPackToken currentValue) {
        TokenParseContext tokenContext = this.parsingContextStack.peek();
        tokenContext.consumeRepetition();
        if (tokenContext.remainingRepetitions == 0) {
            this.parsingContextStack.remove();
        }
        block0 : switch (tokenContext.parsingMode) {
            case MAP_ENTRY: {
                switch (this.mapEntryContext.parsingMode) {
                    case KEY: {
                        this.mapEntryContext.currentKey = this.parseMapKey(currentValue);
                        this.mapEntryContext.parsingMode = MapEntryParsingMode.VALUE;
                        break block0;
                    }
                    case VALUE: {
                        this.parseValue(tokenContext, this.mapEntryContext.currentKey, position, currentValue);
                        this.mapEntryContext.currentKey = "";
                        this.mapEntryContext.parsingMode = MapEntryParsingMode.KEY;
                        break block0;
                    }
                }
                throw new IllegalStateException("Unexpected map entry parsing mode " + this.mapEntryContext.parsingMode.name());
            }
            case ARRAY_ENTRY: {
                int index = tokenContext.repetitions - tokenContext.remainingRepetitions - 1;
                String key = Integer.toString(index);
                this.parseValue(tokenContext, key, position, currentValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown token parsing mode " + tokenContext.parsingMode.name());
            }
        }
    }

    private void parseValue(TokenParseContext tokenContext, String key, int valuePosition, MsgPackToken value) {
        switch (value.getType()) {
            case MAP: {
                this.parseMapValue(tokenContext, key, value);
                break;
            }
            case ARRAY: {
                this.parseArrayValue(tokenContext, key, value);
                break;
            }
            default: {
                this.parsePrimitiveValue(tokenContext, key, valuePosition, value);
            }
        }
    }

    private void parsePrimitiveValue(TokenParseContext tokenContext, String key, int valuePosition, MsgPackToken value) {
        this.msgPackTree.addValueNode(tokenContext.parentNodeId, key, this.documentId, valuePosition, value.getTotalLength());
    }

    private void parseArrayValue(TokenParseContext tokenContext, String key, MsgPackToken value) {
        String arrayNodeId = this.msgPackTree.addArrayNode(tokenContext.parentNodeId, key);
        int arrayElements = value.getSize();
        if (arrayElements > 0) {
            this.parsingContextStack.push(new TokenParseContext(ParsingMode.ARRAY_ENTRY, arrayNodeId, arrayElements));
        }
    }

    private void parseMapValue(TokenParseContext tokenContext, String key, MsgPackToken value) {
        String nodeId = this.msgPackTree.addMapNode(tokenContext.parentNodeId, key);
        int mapElements = value.getSize();
        if (mapElements > 0) {
            this.parsingContextStack.push(new TokenParseContext(ParsingMode.MAP_ENTRY, nodeId, mapElements * 2));
        }
    }

    private String parseMapKey(MsgPackToken currentValue) {
        DirectBuffer valueBuffer = currentValue.getValueBuffer();
        return valueBuffer.getStringWithoutLengthUtf8(0, valueBuffer.capacity());
    }

    private void clear() {
        this.parsingContextStack.clear();
        this.msgPackTree.clear();
    }

    static enum MapEntryParsingMode {
        KEY,
        VALUE;

    }

    static enum ParsingMode {
        MAP_ENTRY,
        ARRAY_ENTRY;

    }

    static class TokenParseContext {
        final ParsingMode parsingMode;
        final String parentNodeId;
        final int repetitions;
        int remainingRepetitions;

        TokenParseContext(ParsingMode parsingMode, String parentNodeId, int repetitions) {
            this.parsingMode = parsingMode;
            this.parentNodeId = parentNodeId;
            this.repetitions = repetitions;
            this.remainingRepetitions = repetitions;
        }

        void consumeRepetition() {
            --this.remainingRepetitions;
        }
    }

    static class MapEntryParseContext {
        private MapEntryParsingMode parsingMode;
        private String currentKey;

        MapEntryParseContext() {
        }
    }
}

