/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.mapping.MsgPackTree;
import io.zeebe.msgpack.mapping.MsgPackTreeNodeIdConstructor;
import io.zeebe.msgpack.spec.MsgPackWriter;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MsgPackDocumentTreeWriter {
    private final MsgPackWriter msgPackWriter = new MsgPackWriter();
    private final MutableDirectBuffer resultingBuffer;
    private final DirectBuffer nodeName;
    private MsgPackTree documentTree;

    public MsgPackDocumentTreeWriter(int initialDocumentSize) {
        this.resultingBuffer = new ExpandableArrayBuffer(initialDocumentSize);
        this.nodeName = new UnsafeBuffer(0L, 0);
    }

    public int write(MsgPackTree documentTree) {
        this.documentTree = documentTree;
        this.msgPackWriter.wrap(this.resultingBuffer, 0);
        if (documentTree.size() > 0) {
            String startNode = "$";
            this.writeNode("", "$", false);
        } else {
            this.msgPackWriter.writeNil();
        }
        return this.msgPackWriter.getOffset();
    }

    private void writeNode(String parentId, String nodeName, boolean isArray) {
        String nodeId;
        if (!parentId.isEmpty() && !isArray) {
            this.nodeName.wrap(nodeName.getBytes());
            this.msgPackWriter.writeString(this.nodeName);
        }
        String string = nodeId = parentId.isEmpty() ? nodeName : MsgPackTreeNodeIdConstructor.construct(parentId, nodeName);
        if (this.documentTree.isValueNode(nodeId)) {
            this.documentTree.writeValueNode(this.msgPackWriter, nodeId);
        } else {
            boolean isArrayNode = this.documentTree.isArrayNode(nodeId);
            Set<String> childs = this.documentTree.getChildren(nodeId);
            if (isArrayNode) {
                this.msgPackWriter.writeArrayHeader(childs.size());
            } else {
                this.msgPackWriter.writeMapHeader(childs.size());
            }
            for (String child : childs) {
                this.writeNode(nodeId, child, isArrayNode);
            }
        }
    }

    public MutableDirectBuffer getResult() {
        return this.resultingBuffer;
    }
}

