/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.query;

import io.zeebe.util.allocation.BufferAllocator;
import io.zeebe.util.allocation.HeapBufferAllocator;
import io.zeebe.util.collection.CompactList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public abstract class AbstractDynamicContext {
    protected final CompactList context;
    protected final UnsafeBuffer cursorView = new UnsafeBuffer(0L, 0);
    protected final UnsafeBuffer dynamicContextView = new UnsafeBuffer(0L, 0);
    protected final int dynamicContextSize;
    protected final int elementSize;
    protected final int staticElementSize;
    protected final DirectBuffer emptyElement;

    public AbstractDynamicContext(int capacity, int staticElementSize, int dynamicContextSize) {
        this.staticElementSize = staticElementSize;
        this.dynamicContextSize = dynamicContextSize;
        this.elementSize = staticElementSize + dynamicContextSize;
        this.context = new CompactList(this.elementSize, capacity, (BufferAllocator)new HeapBufferAllocator());
        this.emptyElement = new UnsafeBuffer(new byte[this.elementSize]);
    }

    public boolean hasElements() {
        return this.context.size() > 0;
    }

    public int size() {
        return this.context.size();
    }

    public void moveTo(int element) {
        this.context.wrap(element, (MutableDirectBuffer)this.cursorView);
    }

    public void moveToLastElement() {
        this.context.wrap(this.context.size() - 1, (MutableDirectBuffer)this.cursorView);
    }

    public void appendElement() {
        this.context.add(this.emptyElement, 0, this.elementSize);
        this.moveToLastElement();
    }

    public void removeLastElement() {
        this.context.remove(this.context.size() - 1);
        if (this.size() > 0) {
            this.moveToLastElement();
        }
    }

    public MutableDirectBuffer dynamicContext() {
        if (this.dynamicContextSize > 0) {
            this.dynamicContextView.wrap((DirectBuffer)this.cursorView, this.staticElementSize, this.dynamicContextSize);
        } else {
            this.dynamicContextView.wrap(0L, 0);
        }
        return this.dynamicContextView;
    }

    public void clear() {
        this.context.clear();
    }
}

