/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.query;

import io.zeebe.msgpack.filter.MsgPackFilter;
import io.zeebe.msgpack.query.MsgPackFilterContext;
import io.zeebe.msgpack.query.MsgPackTokenVisitor;
import io.zeebe.msgpack.query.MsgPackTraversalContext;
import io.zeebe.msgpack.spec.MsgPackCodes;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackType;
import io.zeebe.util.allocation.BufferAllocator;
import io.zeebe.util.allocation.HeapBufferAllocator;
import io.zeebe.util.collection.CompactList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MsgPackQueryExecutor
implements MsgPackTokenVisitor {
    private static final int MAX_TRAVERSAL_DEPTH = 30;
    private static final int MAX_RESULTS = 1000;
    private static final int RESULT_SIZE = 8;
    private static final int RESULT_POSITION_OFFSET = 0;
    private static final int RESULT_LENGTH_OFFSET = 4;
    private MsgPackFilter[] filters;
    private MsgPackFilterContext filterInstances;
    private int numFilterInstances;
    private final CompactList matchingPositions;
    private final UnsafeBuffer currentResultView = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer resultWriteBuffer = new UnsafeBuffer(new byte[8]);
    private int matchingContainer = -1;
    private int matchingContainerStartPosition;
    private final MsgPackTraversalContext context = new MsgPackTraversalContext(30, 4);

    public MsgPackQueryExecutor() {
        this.matchingPositions = new CompactList(8, 1000, (BufferAllocator)new HeapBufferAllocator());
    }

    public void init(MsgPackFilter[] filters, MsgPackFilterContext filterInstances) {
        this.filters = filters;
        this.filterInstances = filterInstances;
        this.numFilterInstances = filterInstances.size();
        this.matchingPositions.clear();
    }

    @Override
    public void visitElement(int position, MsgPackToken currentValue) {
        MsgPackType currentValueType;
        int currentFilter = 0;
        if (this.context.hasElements()) {
            this.context.moveToLastElement();
            this.context.currentElement(this.context.currentElement() + 1);
            currentFilter = this.context.applyingFilter();
        }
        boolean filterMatch = false;
        if (currentFilter >= 0) {
            this.filterInstances.moveTo(currentFilter);
            MsgPackFilter filter = this.filters[this.filterInstances.filterId()];
            filterMatch = filter.matches(this.context, (DirectBuffer)this.filterInstances.dynamicContext(), currentValue);
        }
        if (MsgPackType.ARRAY == (currentValueType = currentValue.getType()) || MsgPackType.MAP == currentValueType) {
            this.context.appendElement();
            this.context.currentElement(-1);
            this.context.numElements(currentValueType == MsgPackType.MAP ? currentValue.getSize() * 2 : currentValue.getSize());
            this.context.applyingFilter(-1);
            this.context.setIsMap(MsgPackType.MAP == currentValueType);
        }
        if (filterMatch) {
            if (this.isLastFilter(currentFilter)) {
                if (currentValue.getType().isScalar()) {
                    this.addResult(position, currentValue.getTotalLength());
                } else {
                    this.matchingContainer = this.context.size() - 1;
                    this.matchingContainerStartPosition = position;
                }
            } else {
                this.context.applyingFilter(currentFilter + 1);
            }
        }
        while (this.context.hasElements() && this.context.currentElement() + 1 >= this.context.numElements()) {
            if (this.matchingContainer == this.context.size() - 1) {
                this.addResult(this.matchingContainerStartPosition, position + currentValue.getTotalLength() - this.matchingContainerStartPosition);
                this.matchingContainer = -1;
            }
            this.context.removeLastElement();
        }
    }

    private boolean isLastFilter(int filterIndex) {
        return filterIndex + 1 == this.numFilterInstances;
    }

    public int numResults() {
        return this.matchingPositions.size();
    }

    public void moveToResult(int index) {
        this.matchingPositions.wrap(index, (MutableDirectBuffer)this.currentResultView);
    }

    public int currentResultPosition() {
        return this.currentResultView.getInt(0);
    }

    public int currentResultLength() {
        return this.currentResultView.getInt(4);
    }

    public boolean isCurrentResultAMap(DirectBuffer document) {
        byte headerByte = document.getByte(this.currentResultPosition());
        return MsgPackCodes.isMap((byte)headerByte);
    }

    private void addResult(int position, int length) {
        this.resultWriteBuffer.putInt(0, position);
        this.resultWriteBuffer.putInt(4, length);
        this.matchingPositions.add((DirectBuffer)this.resultWriteBuffer);
    }
}

