/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.query;

import io.zeebe.msgpack.jsonpath.JsonPathQuery;
import io.zeebe.msgpack.query.MsgPackQueryExecutor;
import io.zeebe.msgpack.query.MsgPackTraverser;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackType;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MsgPackQueryProcessor {
    private final MsgPackQueryExecutor queryExecutor = new MsgPackQueryExecutor();
    private final MsgPackTraverser traverser = new MsgPackTraverser();
    private final MsgPackReader reader = new MsgPackReader();
    private final QueryResults results = new QueryResults();
    private final QueryResult result = new QueryResult();

    public QueryResults process(JsonPathQuery query, DirectBuffer data) {
        this.queryExecutor.init(query.getFilters(), query.getFilterInstances());
        this.traverser.wrap(data, 0, data.capacity());
        this.traverser.traverse(this.queryExecutor);
        this.results.wrap(data);
        return this.results;
    }

    public final class ArrayResult {
        private final UnsafeBuffer resultBuffer = new UnsafeBuffer();
        private int size;
        private int currentIndex;

        private void wrap(int size) {
            this.size = size;
            this.currentIndex = -1;
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public DirectBuffer getElement(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException(String.format("index: %d, size: %d", index, this.size));
            }
            if (this.currentIndex > index) {
                throw new IllegalStateException(String.format("index: %d, current index: %d", index, this.currentIndex));
            }
            if (this.currentIndex == index) {
                return this.resultBuffer;
            }
            int skipValues = index - this.currentIndex;
            if (skipValues > 1) {
                MsgPackQueryProcessor.this.reader.skipValues((long)(skipValues - 1));
            }
            this.currentIndex = index;
            int offset = MsgPackQueryProcessor.this.reader.getOffset();
            MsgPackQueryProcessor.this.reader.skipValue();
            int length = MsgPackQueryProcessor.this.reader.getOffset() - offset;
            this.resultBuffer.wrap(MsgPackQueryProcessor.this.reader.getBuffer(), offset, length);
            return this.resultBuffer;
        }

        public void forEach(Consumer<DirectBuffer> consumer) {
            for (int i = 0; i < this.size; ++i) {
                consumer.accept(this.getElement(i));
            }
        }
    }

    public final class QueryResult {
        private final UnsafeBuffer resultBuffer = new UnsafeBuffer();
        private final ArrayResult arrayResult = new ArrayResult();
        private MsgPackToken token;

        private void wrap(MsgPackToken token) {
            this.token = token;
        }

        public boolean isString() {
            return this.token.getType() == MsgPackType.STRING;
        }

        public boolean isLong() {
            return this.token.getType() == MsgPackType.INTEGER;
        }

        public boolean isArray() {
            return this.token.getType() == MsgPackType.ARRAY;
        }

        public DirectBuffer getString() {
            if (!this.isString()) {
                throw new RuntimeException(String.format("expected STRING but found '%s'", this.token.getType()));
            }
            return this.token.getValueBuffer();
        }

        public DirectBuffer getLongAsString() {
            if (!this.isLong()) {
                throw new RuntimeException(String.format("expected LONG but found '%s'", this.token.getType()));
            }
            long key = this.token.getIntegerValue();
            String converted = String.valueOf(key);
            this.resultBuffer.wrap(converted.getBytes());
            return this.resultBuffer;
        }

        public ArrayResult getArray() {
            if (!this.isArray()) {
                throw new RuntimeException(String.format("expected ARRAY but found '%s'", this.token.getType()));
            }
            int size = this.token.getSize();
            this.arrayResult.wrap(size);
            return this.arrayResult;
        }

        public DirectBuffer getValue() {
            this.resultBuffer.wrap(MsgPackQueryProcessor.this.reader.getBuffer());
            return this.resultBuffer;
        }

        public String getType() {
            return this.token.getType().name();
        }
    }

    public final class QueryResults {
        private DirectBuffer data;

        private void wrap(DirectBuffer data) {
            this.data = data;
        }

        public int size() {
            return MsgPackQueryProcessor.this.queryExecutor.numResults();
        }

        public QueryResult getSingleResult() {
            if (this.size() == 1) {
                MsgPackQueryProcessor.this.result.wrap(this.readToken(0));
                return MsgPackQueryProcessor.this.result;
            }
            if (this.size() == 0) {
                throw new RuntimeException("no result found");
            }
            throw new RuntimeException("found more than one result");
        }

        private MsgPackToken readToken(int index) {
            MsgPackQueryProcessor.this.queryExecutor.moveToResult(index);
            MsgPackQueryProcessor.this.reader.wrap(this.data, MsgPackQueryProcessor.this.queryExecutor.currentResultPosition(), MsgPackQueryProcessor.this.queryExecutor.currentResultLength());
            return MsgPackQueryProcessor.this.reader.readToken();
        }
    }
}

