/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.util;

import org.agrona.DirectBuffer;

public final class ByteUtil {
    public static boolean equal(byte[] arr1, DirectBuffer buf2, int buf2Offset, int length) {
        if (arr1.length != length || buf2.capacity() < buf2Offset + length) {
            return false;
        }
        boolean equal = true;
        for (int i = 0; i < arr1.length && equal; ++i) {
            equal = arr1[i] == buf2.getByte(buf2Offset + i);
        }
        return equal;
    }

    public static boolean equal(DirectBuffer buf1, int buf1Offset, int buf1Length, DirectBuffer buf2, int buf2Offset, int buf2Length) {
        if (buf1Length != buf2Length) {
            return false;
        }
        boolean equal = true;
        for (int i = 0; i < buf1Length && equal; ++i) {
            equal = buf1.getByte(buf1Offset + i) == buf2.getByte(buf2Offset + i);
        }
        return equal;
    }

    public static String bytesToBinary(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String binaryString = Integer.toBinaryString(Byte.toUnsignedInt(bytes[i]));
            int missingLeadingZeroes = 8 - binaryString.length();
            for (int j = 0; j < missingLeadingZeroes; ++j) {
                sb.append("0");
            }
            sb.append(binaryString);
            sb.append(", ");
        }
        return sb.toString();
    }

    public static boolean isNumeric(DirectBuffer buffer, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            byte curr = buffer.getByte(i);
            if (curr >= 48 && curr <= 57) continue;
            return false;
        }
        return true;
    }

    public static int parseInteger(DirectBuffer buffer, int offset, int length) {
        int value = 0;
        int exponent = 1;
        for (int i = length - 1; i >= 0; --i) {
            byte curr = buffer.getByte(offset + i);
            value += (curr - 48) * exponent;
            exponent *= 10;
        }
        return value;
    }
}

