/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.engine;

import io.zeebe.containers.ZeebeContainer;
import io.zeebe.containers.cluster.ZeebeCluster;
import io.zeebe.containers.engine.ContainerEngine;
import io.zeebe.containers.engine.DebugReceiverStream;
import io.zeebe.containers.engine.InfiniteList;
import io.zeebe.containers.engine.ZeebeClusterEngine;
import io.zeebe.containers.engine.ZeebeContainerEngine;
import java.time.Duration;
import org.apiguardian.api.API;

@API(status=API.Status.EXPERIMENTAL)
public final class ContainerEngines {
    private ContainerEngines() {
    }

    public static ContainerEngine of() {
        return ContainerEngines.of(Duration.ZERO);
    }

    public static ContainerEngine of(Duration timeout) {
        return ContainerEngines.of(timeout, new ZeebeContainer());
    }

    public static ContainerEngine of(ZeebeContainer container) {
        return ContainerEngines.of(Duration.ZERO, container);
    }

    public static ContainerEngine of(Duration timeout, ZeebeContainer container) {
        InfiniteList records = new InfiniteList(timeout);
        return new ZeebeContainerEngine<ZeebeContainer>(container, new DebugReceiverStream(records));
    }

    public static ContainerEngine of(ZeebeCluster cluster) {
        return ContainerEngines.of(Duration.ZERO, cluster);
    }

    public static ContainerEngine of(Duration timeout, ZeebeCluster cluster) {
        InfiniteList records = new InfiniteList(timeout);
        return new ZeebeClusterEngine(cluster, new DebugReceiverStream(records));
    }
}

