/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.engine;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.jcip.annotations.ThreadSafe;
import org.agrona.LangUtil;

@ThreadSafe
final class InfiniteIterator<T>
implements Iterator<T> {
    private final List<T> items;
    private final Duration timeout;
    private int cursor = 0;

    InfiniteIterator(List<T> items, Duration timeout) {
        this.items = items;
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        List<T> list = this.items;
        synchronized (list) {
            try {
                Duration currentTimeout = this.timeout;
                while (this.hasTimeRemaining(currentTimeout) && this.cursor >= this.items.size()) {
                    long currentNanos = System.nanoTime();
                    this.items.wait(currentTimeout.toMillis(), currentTimeout.getNano());
                    currentTimeout = Duration.of(currentNanos - System.nanoTime(), ChronoUnit.NANOS);
                }
                return this.cursor < this.items.size();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        T item;
        List<T> list = this.items;
        synchronized (list) {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            item = this.items.get(this.cursor);
            ++this.cursor;
        }
        return item;
    }

    private boolean hasTimeRemaining(Duration duration) {
        return !duration.isNegative() && !duration.isZero();
    }
}

