/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.engine;

import io.zeebe.containers.ZeebeBrokerNode;
import io.zeebe.containers.ZeebeContainer;
import io.zeebe.containers.cluster.ZeebeCluster;
import io.zeebe.containers.engine.ContainerEngine;
import io.zeebe.containers.engine.DebugReceiverStream;
import io.zeebe.containers.engine.InfiniteList;
import io.zeebe.containers.engine.ZeebeClusterEngine;
import io.zeebe.containers.engine.ZeebeContainerEngine;
import io.zeebe.containers.exporter.DebugReceiver;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

@API(status=API.Status.INTERNAL)
final class ContainerEngineBuilder
implements ContainerEngine.Builder {
    private static final Duration DEFAULT_IDLE_PERIOD = Duration.ofSeconds(1L);
    private static final Duration DEFAULT_GRACE_PERIOD = Duration.ZERO;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerEngineBuilder.class);
    private static final Duration MINIMUM_IDLE_PERIOD = Duration.ofMillis(100L);
    private Holder<? extends GenericContainer<?>> container;
    private ZeebeCluster cluster;
    private Duration idlePeriod;
    private Duration gracePeriod;
    private boolean autoAcknowledge;
    private int debugReceiverPort;
    private DebugReceiver debugReceiver;

    ContainerEngineBuilder() {
    }

    @Override
    public <T extends GenericContainer<T> & ZeebeBrokerNode<T>> ContainerEngineBuilder withContainer(T container) {
        if (this.cluster != null) {
            LOGGER.warn("Setting a container will overwrite the previously assigned cluster");
            this.cluster = null;
        }
        this.container = new Holder((GenericContainer<T>)Objects.requireNonNull(container, "must specify a container"), null);
        return this;
    }

    @Override
    public ContainerEngineBuilder withCluster(ZeebeCluster cluster) {
        if (this.container != null) {
            LOGGER.warn("Setting a cluster will overwrite the previously assigned container");
            this.container = null;
        }
        this.cluster = Objects.requireNonNull(cluster, "must specify a cluster");
        return this;
    }

    @Override
    public ContainerEngineBuilder withIdlePeriod(Duration idlePeriod) {
        Objects.requireNonNull(idlePeriod, "must specify an idle period");
        if (idlePeriod.compareTo(MINIMUM_IDLE_PERIOD) < 0) {
            throw new IllegalArgumentException(String.format("Cannot assign idle period [%s] less than the minimum [%s]", idlePeriod, MINIMUM_IDLE_PERIOD));
        }
        this.idlePeriod = idlePeriod;
        return this;
    }

    @Override
    public ContainerEngineBuilder withGracePeriod(Duration gracePeriod) {
        Objects.requireNonNull(gracePeriod, "must specify an grace period");
        if (gracePeriod.isNegative()) {
            LOGGER.warn("Cannot assign negative grace period {}; will default to 0", (Object)gracePeriod);
            this.gracePeriod = DEFAULT_GRACE_PERIOD;
        } else {
            this.gracePeriod = gracePeriod;
        }
        return this;
    }

    @Override
    public ContainerEngine.Builder withAutoAcknowledge(boolean autoAcknowledge) {
        this.autoAcknowledge = autoAcknowledge;
        return this;
    }

    @Override
    public ContainerEngine.Builder withDebugReceiverPort(int debugReceiverPort) {
        if (debugReceiverPort < 0) {
            throw new IllegalArgumentException(String.format("Debug receiver port must be greater than or equal to 0, but %d was given", debugReceiverPort));
        }
        this.debugReceiverPort = debugReceiverPort;
        return this;
    }

    @Override
    public ContainerEngine.Builder withDebugReceiver(DebugReceiver debugReceiver) {
        this.debugReceiver = Objects.requireNonNull(debugReceiver, "must specify a debug receiver");
        return this;
    }

    @Override
    public ContainerEngine build() {
        Duration listGracePeriod = Optional.ofNullable(this.gracePeriod).orElse(DEFAULT_GRACE_PERIOD);
        Duration receiveIdlePeriod = Optional.ofNullable(this.idlePeriod).orElse(DEFAULT_IDLE_PERIOD);
        InfiniteList records = new InfiniteList(listGracePeriod);
        DebugReceiver receiver = Optional.ofNullable(this.debugReceiver).orElse(new DebugReceiver(records::add, this.debugReceiverPort, this.autoAcknowledge));
        DebugReceiverStream recordStream = new DebugReceiverStream(records, receiver, receiveIdlePeriod);
        try {
            if (this.container != null) {
                return new ZeebeContainerEngine<GenericContainer>(((Holder)this.container).container, recordStream);
            }
            if (this.cluster != null) {
                return new ZeebeClusterEngine(this.cluster, recordStream);
            }
            return new ZeebeContainerEngine<ZeebeContainer>(new ZeebeContainer(), recordStream);
        }
        catch (Exception e) {
            recordStream.close();
            throw e;
        }
    }

    private static final class Holder<T extends GenericContainer<T> & ZeebeBrokerNode<T>> {
        private final T container;

        private Holder(T container) {
            this.container = container;
        }

        /* synthetic */ Holder(GenericContainer x0, 1 x1) {
            this(x0);
        }
    }
}

