/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.containers.engine;

import io.zeebe.containers.engine.InfiniteIterator;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.apiguardian.api.API;

@ThreadSafe
@API(status=API.Status.INTERNAL)
final class InfiniteList<T>
implements Iterable<T> {
    private final Duration timeout;
    private final List<T> items;

    InfiniteList() {
        this(Duration.ZERO);
    }

    InfiniteList(Duration timeout) {
        this.timeout = timeout;
        this.items = new LinkedList<T>();
    }

    @Override
    public Iterator<T> iterator() {
        return new InfiniteIterator<T>(this.items, this.timeout);
    }

    int size() {
        return this.items.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T item) {
        List<T> list = this.items;
        synchronized (list) {
            this.items.add(item);
            this.items.notifyAll();
        }
    }
}

