/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.xray_udp;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Call;
import zipkin2.Span;
import zipkin2.reporter.Reporter;
import zipkin2.storage.xray_udp.XRayUDPStorage;

public class XRayUDPReporter
implements Reporter<Span>,
Closeable {
    static final Logger logger = Logger.getLogger(XRayUDPReporter.class.getName());
    final XRayUDPStorage delegate;

    public static Reporter<Span> create() {
        return new XRayUDPReporter(XRayUDPStorage.newBuilder().build());
    }

    public static Reporter<Span> create(String address) {
        return new XRayUDPReporter(XRayUDPStorage.newBuilder().address(address).build());
    }

    XRayUDPReporter(XRayUDPStorage delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public void report(Span span) {
        block6: {
            Call call;
            if (!span.tags().containsKey("aws.xray.sdk")) {
                span = span.toBuilder().putTag("aws.xray.sdk", "Zipkin Brave").build();
            }
            try {
                call = this.delegate.accept(Collections.singletonList(span));
            }
            catch (RuntimeException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "couldn't convert span " + span + " into a UDP message", e);
                }
                return;
            }
            try {
                call.execute();
            }
            catch (IOException | RuntimeException e) {
                if (!logger.isLoggable(Level.FINE)) break block6;
                logger.log(Level.FINE, "couldn't send UDP message", e);
            }
        }
    }

    public String toString() {
        return "XRayUDPReporter(" + this.delegate + ")";
    }
}

