/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.xray_udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.SpanConsumer;
import zipkin2.storage.SpanStore;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.xray_udp.UDPMessageEncoder;

public final class XRayUDPStorage
extends StorageComponent
implements SpanStore,
SpanConsumer {
    static final int PACKET_LENGTH = 262144;
    static final ThreadLocal<byte[]> BUF = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[262144];
        }
    };
    final InetSocketAddress address;
    volatile DatagramSocket socket;
    volatile boolean closeCalled;

    public static Builder newBuilder() {
        return new Builder();
    }

    XRayUDPStorage(InetSocketAddress address) {
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatagramSocket socket() {
        if (this.socket == null) {
            XRayUDPStorage xRayUDPStorage = this;
            synchronized (xRayUDPStorage) {
                if (this.socket == null) {
                    try {
                        this.socket = new DatagramSocket();
                    }
                    catch (SocketException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        return this.socket;
    }

    public SpanStore spanStore() {
        return this;
    }

    public SpanConsumer spanConsumer() {
        return this;
    }

    public Call<Void> accept(List<Span> spans) {
        if (this.closeCalled) {
            throw new IllegalStateException("closed");
        }
        if (spans.isEmpty()) {
            return Call.create(null);
        }
        int length = spans.size();
        if (length == 1) {
            return new UDPCall(Collections.singletonList(UDPMessageEncoder.encode(spans.get(0))));
        }
        ArrayList<byte[]> encoded = new ArrayList<byte[]>(length);
        for (int i = 0; i < length; ++i) {
            encoded.add(UDPMessageEncoder.encode(spans.get(i)));
        }
        return new UDPCall(encoded);
    }

    void send(byte[] message) throws IOException {
        DatagramPacket packet = new DatagramPacket(BUF.get(), 262144, this.address);
        packet.setData(message);
        this.socket().send(packet);
    }

    public synchronized void close() {
        if (this.closeCalled) {
            return;
        }
        DatagramSocket socket = this.socket;
        if (socket != null) {
            socket.close();
        }
        this.closeCalled = true;
    }

    public Call<List<List<Span>>> getTraces(QueryRequest queryRequest) {
        throw new UnsupportedOperationException("This is collector-only at the moment");
    }

    public Call<List<Span>> getTrace(String s) {
        throw new UnsupportedOperationException("This is collector-only at the moment");
    }

    public Call<List<String>> getServiceNames() {
        throw new UnsupportedOperationException("This is collector-only at the moment");
    }

    public Call<List<String>> getSpanNames(String s) {
        throw new UnsupportedOperationException("This is collector-only at the moment");
    }

    public Call<List<DependencyLink>> getDependencies(long l, long l1) {
        throw new UnsupportedOperationException("This is collector-only at the moment");
    }

    public final String toString() {
        return "XRayUDPStorage{address=" + this.address + "}";
    }

    class UDPCall
    extends Call.Base<Void> {
        private final List<byte[]> messages;

        UDPCall(List<byte[]> messages) {
            this.messages = messages;
        }

        protected Void doExecute() throws IOException {
            for (byte[] message : this.messages) {
                XRayUDPStorage.this.send(message);
            }
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                this.doExecute();
                callback.onSuccess(null);
            }
            catch (IOException | Error | RuntimeException e) {
                UDPCall.propagateIfFatal((Throwable)e);
                callback.onError(e);
            }
        }

        public Call<Void> clone() {
            return new UDPCall(this.messages);
        }
    }

    public static final class Builder
    extends StorageComponent.Builder {
        String address;

        public Builder strictTraceId(boolean strictTraceId) {
            return this;
        }

        public Builder searchEnabled(boolean searchEnabled) {
            return this;
        }

        public Builder address(String address) {
            if (address == null) {
                throw new IllegalArgumentException("address == null");
            }
            this.address = address;
            return this;
        }

        public XRayUDPStorage build() {
            String address = this.address;
            if (address == null && ((address = System.getenv("AWS_XRAY_DAEMON_ADDRESS")) == null || address.isEmpty())) {
                return new XRayUDPStorage(new InetSocketAddress("localhost", 2000));
            }
            String[] splitAddress = address.split(":", 2);
            String host = splitAddress[0];
            Integer port = null;
            try {
                if (splitAddress.length == 2) {
                    port = Integer.parseInt(splitAddress[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new XRayUDPStorage(new InetSocketAddress(host, (int)port));
        }

        Builder() {
        }
    }
}

