/*
 * Decompiled with CFR 0.152.
 */
package brave.context.log4j2;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.apache.logging.log4j.ThreadContext;

public final class ThreadContextCurrentTraceContext
extends CurrentTraceContext {
    final CurrentTraceContext delegate;

    public static ThreadContextCurrentTraceContext create() {
        return ThreadContextCurrentTraceContext.create(CurrentTraceContext.Default.inheritable());
    }

    public static ThreadContextCurrentTraceContext create(CurrentTraceContext delegate) {
        return new ThreadContextCurrentTraceContext(delegate);
    }

    ThreadContextCurrentTraceContext(CurrentTraceContext delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public TraceContext get() {
        return this.delegate.get();
    }

    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        final String previousTraceId = ThreadContext.get((String)"traceId");
        final String previousParentId = ThreadContext.get((String)"parentId");
        final String previousSpanId = ThreadContext.get((String)"spanId");
        if (currentSpan != null) {
            ThreadContext.put((String)"traceId", (String)currentSpan.traceIdString());
            long parentId = currentSpan.parentIdAsLong();
            ThreadContextCurrentTraceContext.replace("parentId", parentId != 0L ? HexCodec.toLowerHex((long)parentId) : null);
            ThreadContext.put((String)"spanId", (String)HexCodec.toLowerHex((long)currentSpan.spanId()));
        } else {
            ThreadContext.remove((String)"traceId");
            ThreadContext.remove((String)"parentId");
            ThreadContext.remove((String)"spanId");
        }
        final CurrentTraceContext.Scope scope = this.delegate.newScope(currentSpan);
        class ThreadContextCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            ThreadContextCurrentTraceContextScope() {
            }

            public void close() {
                scope.close();
                ThreadContextCurrentTraceContext.replace("traceId", previousTraceId);
                ThreadContextCurrentTraceContext.replace("parentId", previousParentId);
                ThreadContextCurrentTraceContext.replace("spanId", previousSpanId);
            }
        }
        return new ThreadContextCurrentTraceContextScope();
    }

    static void replace(String key, @Nullable String value) {
        if (value != null) {
            ThreadContext.put((String)key, (String)value);
        } else {
            ThreadContext.remove((String)key);
        }
    }
}

