/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

final class TraceContextSingle<T>
extends Single<T> {
    final SingleSource<T> source;
    final CurrentTraceContext currentTraceContext;
    final TraceContext assemblyContext;

    TraceContextSingle(SingleSource<T> source, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
        this.source = source;
        this.currentTraceContext = currentTraceContext;
        this.assemblyContext = assemblyContext;
    }

    protected void subscribeActual(SingleObserver<? super T> s) {
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
            this.source.subscribe(new Observer(s, this.currentTraceContext, this.assemblyContext));
        }
    }

    static final class Observer<T>
    implements SingleObserver<T>,
    Disposable {
        final SingleObserver<T> actual;
        final CurrentTraceContext currentTraceContext;
        final TraceContext assemblyContext;
        Disposable d;

        Observer(SingleObserver actual, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
            this.actual = actual;
            this.currentTraceContext = currentTraceContext;
            this.assemblyContext = assemblyContext;
        }

        public void onSubscribe(Disposable d) {
            if (!DisposableHelper.validate((Disposable)this.d, (Disposable)d)) {
                return;
            }
            this.d = d;
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onSubscribe((Disposable)this);
            }
        }

        public void onError(Throwable t) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onError(t);
            }
        }

        public void onSuccess(T value) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);){
                this.actual.onSuccess(value);
            }
        }

        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        public void dispose() {
            this.d.dispose();
        }
    }
}

