/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2.internal;

import brave.context.rxjava2.internal.Util;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;

final class TraceContextMaybeObserver<T>
implements MaybeObserver<T>,
Disposable {
    final MaybeObserver<T> downstream;
    final CurrentTraceContext contextScoper;
    final TraceContext assembled;
    Disposable upstream;

    TraceContextMaybeObserver(MaybeObserver<T> downstream, CurrentTraceContext contextScoper, TraceContext assembled) {
        this.downstream = downstream;
        this.contextScoper = contextScoper;
        this.assembled = assembled;
    }

    public void onSubscribe(Disposable d) {
        if (!Util.validate(this.upstream, d)) {
            return;
        }
        this.upstream = d;
        this.downstream.onSubscribe((Disposable)this);
    }

    public void onError(Throwable t) {
        try (CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);){
            this.downstream.onError(t);
        }
    }

    public void onSuccess(T value) {
        try (CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);){
            this.downstream.onSuccess(value);
        }
    }

    public void onComplete() {
        try (CurrentTraceContext.Scope scope = this.contextScoper.maybeScope(this.assembled);){
            this.downstream.onComplete();
        }
    }

    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    public void dispose() {
        this.upstream.dispose();
    }
}

