/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

final class TraceContextSingle<T>
extends Single<T> {
    final SingleSource<T> source;
    final CurrentTraceContext currentTraceContext;
    final TraceContext assemblyContext;

    TraceContextSingle(SingleSource<T> source, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
        this.source = source;
        this.currentTraceContext = currentTraceContext;
        this.assemblyContext = assemblyContext;
    }

    protected void subscribeActual(SingleObserver<? super T> s) {
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.source.subscribe(new Observer(s, this.currentTraceContext, this.assemblyContext));
        }
        finally {
            scope.close();
        }
    }

    static final class Observer<T>
    implements SingleObserver<T>,
    Disposable {
        final SingleObserver<T> actual;
        final CurrentTraceContext currentTraceContext;
        final TraceContext assemblyContext;
        Disposable d;

        Observer(SingleObserver actual, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
            this.actual = actual;
            this.currentTraceContext = currentTraceContext;
            this.assemblyContext = assemblyContext;
        }

        public void onSubscribe(Disposable d) {
            if (!DisposableHelper.validate((Disposable)this.d, (Disposable)d)) {
                return;
            }
            this.d = d;
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
            try {
                this.actual.onSubscribe((Disposable)this);
            }
            finally {
                scope.close();
            }
        }

        public void onError(Throwable t) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
            try {
                this.actual.onError(t);
            }
            finally {
                scope.close();
            }
        }

        public void onSuccess(T value) {
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
            try {
                this.actual.onSuccess(value);
            }
            finally {
                scope.close();
            }
        }

        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        public void dispose() {
            this.d.dispose();
        }
    }
}

