/*
 * Decompiled with CFR 0.152.
 */
package brave.context.rxjava2;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Subscriber;

final class TraceContextSubscriber<T>
extends BasicFuseableSubscriber<T, T> {
    final CurrentTraceContext currentTraceContext;
    final TraceContext assemblyContext;

    TraceContextSubscriber(Subscriber actual, CurrentTraceContext currentTraceContext, TraceContext assemblyContext) {
        super(actual);
        this.currentTraceContext = currentTraceContext;
        this.assemblyContext = assemblyContext;
    }

    public void onNext(T t) {
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.actual.onNext(t);
        }
        finally {
            scope.close();
        }
    }

    public void onError(Throwable t) {
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.actual.onError(t);
        }
        finally {
            scope.close();
        }
    }

    public void onComplete() {
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.assemblyContext);
        try {
            this.actual.onComplete();
        }
        finally {
            scope.close();
        }
    }

    public int requestFusion(int mode) {
        QueueSubscription qs = this.qs;
        if (qs != null) {
            int m;
            this.sourceMode = m = qs.requestFusion(mode);
            return m;
        }
        return 0;
    }

    public T poll() throws Exception {
        return (T)this.qs.poll();
    }
}

