/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.Span;
import brave.dubbo.rpc.DubboClientRequest;
import brave.dubbo.rpc.DubboClientResponse;
import brave.dubbo.rpc.DubboRequest;
import brave.dubbo.rpc.DubboServerRequest;
import brave.dubbo.rpc.DubboServerResponse;
import brave.dubbo.rpc.TracingFilter;
import brave.internal.Nullable;
import brave.rpc.RpcClientHandler;
import brave.rpc.RpcClientRequest;
import brave.rpc.RpcClientResponse;
import brave.rpc.RpcServerHandler;
import brave.rpc.RpcServerResponse;
import com.alibaba.dubbo.rpc.Result;

abstract class FinishSpan {
    final Span span;
    final Result result;

    static void finish(TracingFilter filter, DubboRequest request, @Nullable Result result, @Nullable Throwable error, Span span) {
        if (request instanceof RpcClientRequest) {
            filter.clientHandler.handleReceive((RpcClientResponse)new DubboClientResponse((DubboClientRequest)request, result, error), span);
        } else {
            filter.serverHandler.handleSend((RpcServerResponse)new DubboServerResponse((DubboServerRequest)request, result, error), span);
        }
    }

    static FinishSpan create(TracingFilter filter, DubboRequest request, Result result, Span span) {
        if (request instanceof DubboClientRequest) {
            return new FinishClientSpan(span, result, filter.clientHandler, (DubboClientRequest)request);
        }
        return new FinishServerSpan(span, result, filter.serverHandler, (DubboServerRequest)request);
    }

    FinishSpan(Span span, Result result) {
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        if (result == null) {
            throw new NullPointerException("result == null");
        }
        this.span = span;
        this.result = result;
    }

    public abstract void accept(@Nullable Object var1, @Nullable Throwable var2);

    static final class FinishClientSpan
    extends FinishSpan {
        final RpcClientHandler clientHandler;
        final DubboClientRequest request;

        FinishClientSpan(Span span, Result result, RpcClientHandler clientHandler, DubboClientRequest request) {
            super(span, result);
            this.clientHandler = clientHandler;
            this.request = request;
        }

        @Override
        public void accept(@Nullable Object unused, @Nullable Throwable error) {
            this.clientHandler.handleReceive((RpcClientResponse)new DubboClientResponse(this.request, this.result, error), this.span);
        }
    }

    static final class FinishServerSpan
    extends FinishSpan {
        final RpcServerHandler serverHandler;
        final DubboServerRequest request;

        FinishServerSpan(Span span, Result result, RpcServerHandler serverHandler, DubboServerRequest request) {
            super(span, result);
            this.serverHandler = serverHandler;
            this.request = request;
        }

        @Override
        public void accept(@Nullable Object unused, @Nullable Throwable error) {
            this.serverHandler.handleSend((RpcServerResponse)new DubboServerResponse(this.request, this.result, error), this.span);
        }
    }
}

