/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.Span;
import brave.internal.Nullable;
import brave.internal.Platform;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import java.net.InetSocketAddress;

final class DubboParser {
    DubboParser() {
    }

    @Nullable
    static String method(Invocation invocation) {
        String methodName = invocation.getMethodName();
        if ("$invoke".equals(methodName)) {
            Object[] arguments = invocation.getArguments();
            methodName = arguments != null && arguments.length > 0 && arguments[0] instanceof String ? (String)arguments[0] : null;
        }
        return methodName != null && !methodName.isEmpty() ? methodName : null;
    }

    @Nullable
    static String service(Invoker<?> invoker) {
        URL url = invoker.getUrl();
        if (url == null) {
            return null;
        }
        String service = url.getServiceInterface();
        return service != null && !service.isEmpty() ? service : null;
    }

    static boolean parseRemoteIpAndPort(Span span) {
        RpcContext rpcContext = RpcContext.getContext();
        InetSocketAddress remoteAddress = rpcContext.getRemoteAddress();
        if (remoteAddress == null) {
            return false;
        }
        return span.remoteIpAndPort(Platform.get().getHostString(remoteAddress), remoteAddress.getPort());
    }

    @Nullable
    static String errorCode(Throwable error) {
        if (error instanceof RpcException) {
            int code = ((RpcException)error).getCode();
            switch (code) {
                case 0: {
                    return "UNKNOWN_EXCEPTION";
                }
                case 1: {
                    return "NETWORK_EXCEPTION";
                }
                case 2: {
                    return "TIMEOUT_EXCEPTION";
                }
                case 3: {
                    return "BIZ_EXCEPTION";
                }
                case 4: {
                    return "FORBIDDEN_EXCEPTION";
                }
                case 5: {
                    return "SERIALIZATION_EXCEPTION";
                }
            }
            return String.valueOf(code);
        }
        return null;
    }
}

