/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tag;
import brave.Tracing;
import brave.dubbo.rpc.DubboClientRequest;
import brave.dubbo.rpc.DubboRequest;
import brave.dubbo.rpc.DubboServerRequest;
import brave.dubbo.rpc.FinishSpan;
import brave.dubbo.rpc.FinishSpanResponseFuture;
import brave.internal.Throwables;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.rpc.RpcClientHandler;
import brave.rpc.RpcClientRequest;
import brave.rpc.RpcResponse;
import brave.rpc.RpcResponseParser;
import brave.rpc.RpcServerHandler;
import brave.rpc.RpcServerRequest;
import brave.rpc.RpcTracing;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.remoting.exchange.ResponseFuture;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import java.util.Map;
import java.util.concurrent.Future;

@Deprecated
@Activate(group={"provider", "consumer"}, value={"tracing"})
public final class TracingFilter
implements Filter {
    static final Tag<Throwable> DUBBO_ERROR_CODE = new Tag<Throwable>("dubbo.error_code"){

        protected String parseValue(Throwable input, TraceContext context) {
            if (!(input instanceof RpcException)) {
                return null;
            }
            return String.valueOf(((RpcException)input).getCode());
        }
    };
    static final RpcResponseParser LEGACY_RESPONSE_PARSER = new RpcResponseParser(){

        public void parse(RpcResponse response, TraceContext context, SpanCustomizer span) {
            DUBBO_ERROR_CODE.tag((Object)response.error(), span);
        }
    };
    CurrentTraceContext currentTraceContext;
    RpcClientHandler clientHandler;
    RpcServerHandler serverHandler;
    volatile boolean isInit = false;

    @Deprecated
    public void setTracing(Tracing tracing) {
        if (tracing == null) {
            throw new NullPointerException("rpcTracing == null");
        }
        this.setRpcTracing(RpcTracing.newBuilder((Tracing)tracing).clientResponseParser(LEGACY_RESPONSE_PARSER).serverResponseParser(LEGACY_RESPONSE_PARSER).build());
    }

    public void setRpcTracing(RpcTracing rpcTracing) {
        if (rpcTracing == null) {
            throw new NullPointerException("rpcTracing == null");
        }
        this.currentTraceContext = rpcTracing.tracing().currentTraceContext();
        this.clientHandler = RpcClientHandler.create((RpcTracing)rpcTracing);
        this.serverHandler = RpcServerHandler.create((RpcTracing)rpcTracing);
        this.isInit = true;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Span span;
        DubboRequest request;
        Span.Kind kind;
        if (!this.isInit) {
            return invoker.invoke(invocation);
        }
        TraceContext invocationContext = this.currentTraceContext.get();
        RpcContext rpcContext = RpcContext.getContext();
        Span.Kind kind2 = kind = rpcContext.isProviderSide() ? Span.Kind.SERVER : Span.Kind.CLIENT;
        if (kind.equals((Object)Span.Kind.CLIENT)) {
            Map attachments = RpcContext.getContext().getAttachments();
            DubboClientRequest clientRequest = new DubboClientRequest(invoker, invocation, attachments);
            request = clientRequest;
            span = this.clientHandler.handleSendWithParent((RpcClientRequest)clientRequest, invocationContext);
        } else {
            DubboServerRequest serverRequest;
            request = serverRequest = new DubboServerRequest(invoker, invocation);
            span = this.serverHandler.handleReceive((RpcServerRequest)serverRequest);
        }
        boolean isSynchronous = true;
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(span.context());
        Result result = null;
        Throwable error = null;
        try {
            result = invoker.invoke(invocation);
            error = result.getException();
            Future future = rpcContext.getFuture();
            if (future != null) {
                if (!(future instanceof FutureAdapter)) {
                    assert (false) : "we can't defer the span finish unless we can access the ResponseFuture";
                    Result result2 = result;
                    return result2;
                }
                isSynchronous = false;
                ResponseFuture original = ((FutureAdapter)future).getFuture();
                TraceContext callbackContext = kind == Span.Kind.CLIENT ? invocationContext : span.context();
                FinishSpanResponseFuture wrapped = new FinishSpanResponseFuture(original, this, request, result, span, callbackContext);
                RpcContext.getContext().setFuture((Future)new FutureAdapter((ResponseFuture)wrapped));
            }
            Result result3 = result;
            return result3;
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Error e) {
            Throwables.propagateIfFatal((Throwable)e);
            error = e;
            throw e;
        }
        finally {
            if (isSynchronous) {
                FinishSpan.finish(this, request, result, error, span);
            }
            scope.close();
        }
    }
}

