/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo.rpc;

import brave.dubbo.rpc.FinishSpan;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;

class TracingResponseCallback
implements ResponseCallback {
    final FinishSpan finishSpan;

    static ResponseCallback create(@Nullable ResponseCallback delegate, FinishSpan finishSpan, CurrentTraceContext currentTraceContext, @Nullable TraceContext context) {
        if (delegate == null) {
            return new TracingResponseCallback(finishSpan);
        }
        return new DelegateAndFinishSpan(finishSpan, delegate, currentTraceContext, context);
    }

    TracingResponseCallback(FinishSpan finishSpan) {
        this.finishSpan = finishSpan;
    }

    public void done(Object response) {
        this.finishSpan.accept(response, null);
    }

    public void caught(Throwable exception) {
        this.finishSpan.accept(null, exception);
    }

    static final class DelegateAndFinishSpan
    extends TracingResponseCallback {
        final ResponseCallback delegate;
        final CurrentTraceContext current;
        @Nullable
        final TraceContext context;

        DelegateAndFinishSpan(FinishSpan finishSpan, ResponseCallback delegate, CurrentTraceContext currentTraceContext, @Nullable TraceContext context) {
            super(finishSpan);
            this.delegate = delegate;
            this.current = currentTraceContext;
            this.context = context;
        }

        @Override
        public void done(Object response) {
            CurrentTraceContext.Scope ws = this.current.maybeScope(this.context);
            try {
                this.delegate.done(response);
            }
            finally {
                super.done(response);
                ws.close();
            }
        }

        @Override
        public void caught(Throwable exception) {
            CurrentTraceContext.Scope ws = this.current.maybeScope(this.context);
            try {
                this.delegate.caught(exception);
            }
            finally {
                super.caught(exception);
                ws.close();
            }
        }
    }
}

