/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.baggage.BaggagePropagation;
import brave.grpc.GrpcClientRequest;
import brave.grpc.GrpcServerRequest;
import brave.grpc.TraceContextBinaryFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.grpc.Metadata;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class GrpcPropagation
implements Propagation<String> {
    static final Metadata.Key<byte[]> GRPC_TRACE_BIN = Metadata.Key.of((String)"grpc-trace-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    static final Metadata.Key<TagsBin> GRPC_TAGS_BIN = Metadata.Key.of((String)"grpc-tags-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<TagsBin>(){

        public byte[] toBytes(TagsBin value) {
            return value.bytes;
        }

        public TagsBin parseBytes(byte[] serialized) {
            if (serialized == null || serialized.length == 0) {
                return null;
            }
            return new TagsBin(serialized);
        }
    });
    final Propagation<String> delegate;

    static Map<String, Metadata.Key<String>> nameToKey(Propagation<String> propagation) {
        LinkedHashMap<String, Metadata.Key<String>> result = new LinkedHashMap<String, Metadata.Key<String>>();
        for (String keyName : propagation.keys()) {
            result.put(keyName, (Metadata.Key<String>)Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        }
        for (String keyName : BaggagePropagation.allKeyNames(propagation)) {
            result.put(keyName, (Metadata.Key<String>)Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        }
        return result;
    }

    static Propagation<String> create(Propagation<String> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        return new GrpcPropagation(delegate);
    }

    GrpcPropagation(Propagation<String> delegate) {
        this.delegate = delegate;
    }

    public List<String> keys() {
        return this.delegate.keys();
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return new GrpcInjector<R>(this, setter);
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        return new GrpcExtractor<R>(this, getter);
    }

    static final class GrpcInjector<R>
    implements TraceContext.Injector<R> {
        final TraceContext.Injector<R> delegate;
        final Propagation.Setter<R, String> setter;

        GrpcInjector(GrpcPropagation propagation, Propagation.Setter<R, String> setter) {
            this.delegate = propagation.delegate.injector(setter);
            this.setter = setter;
        }

        public void inject(TraceContext context, R request) {
            if (request instanceof GrpcClientRequest) {
                byte[] serialized = TraceContextBinaryFormat.toBytes(context);
                Metadata metadata = ((GrpcClientRequest)request).headers;
                metadata.removeAll(GRPC_TRACE_BIN);
                metadata.put(GRPC_TRACE_BIN, (Object)serialized);
                TagsBin tags = (TagsBin)context.findExtra(TagsBin.class);
                if (tags != null) {
                    metadata.removeAll(GRPC_TAGS_BIN);
                    metadata.put(GRPC_TAGS_BIN, (Object)tags);
                }
            }
            this.delegate.inject(context, request);
        }
    }

    static final class GrpcExtractor<R>
    implements TraceContext.Extractor<R> {
        final TraceContext.Extractor<R> delegate;
        final Propagation.Getter<R, String> getter;

        GrpcExtractor(GrpcPropagation propagation, Propagation.Getter<R, String> getter) {
            this.delegate = propagation.delegate.extractor(getter);
            this.getter = getter;
        }

        public TraceContextOrSamplingFlags extract(R request) {
            TraceContext maybeContext;
            if (!(request instanceof GrpcServerRequest)) {
                return this.delegate.extract(request);
            }
            Metadata metadata = ((GrpcClientRequest)request).headers;
            TagsBin tagsBin = (TagsBin)metadata.get(GRPC_TAGS_BIN);
            byte[] bytes = (byte[])metadata.get(GRPC_TRACE_BIN);
            if (bytes != null && (maybeContext = TraceContextBinaryFormat.parseBytes(bytes, tagsBin)) != null) {
                return TraceContextOrSamplingFlags.create((TraceContext)maybeContext);
            }
            TraceContextOrSamplingFlags result = this.delegate.extract(request);
            if (tagsBin == null) {
                return result;
            }
            return result.toBuilder().addExtra((Object)tagsBin).build();
        }
    }

    static final class TagsBin {
        final byte[] bytes;

        TagsBin(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

