/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.Tracing;
import brave.grpc.GrpcClientParser;
import brave.grpc.GrpcParser;
import brave.grpc.GrpcPropagation;
import brave.grpc.GrpcServerParser;
import brave.grpc.MessageProcessor;
import brave.grpc.TracingClientInterceptor;
import brave.grpc.TracingServerInterceptor;
import brave.propagation.Propagation;
import brave.rpc.RpcRequestParser;
import brave.rpc.RpcResponseParser;
import brave.rpc.RpcTracing;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.ServerInterceptor;
import java.util.Map;

public final class GrpcTracing {
    final RpcTracing rpcTracing;
    final Propagation<String> propagation;
    final Map<String, Metadata.Key<String>> nameToKey;
    final boolean grpcPropagationFormatEnabled;
    final MessageProcessor clientMessageProcessor;
    final MessageProcessor serverMessageProcessor;

    public static GrpcTracing create(Tracing tracing) {
        return GrpcTracing.newBuilder(tracing).build();
    }

    public static GrpcTracing create(RpcTracing rpcTracing) {
        return GrpcTracing.newBuilder(rpcTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return GrpcTracing.newBuilder(RpcTracing.newBuilder((Tracing)tracing).clientResponseParser(GrpcParser.LEGACY_RESPONSE_PARSER).serverResponseParser(GrpcParser.LEGACY_RESPONSE_PARSER).build());
    }

    public static Builder newBuilder(RpcTracing rpcTracing) {
        return new Builder(rpcTracing);
    }

    GrpcTracing(Builder builder) {
        this.rpcTracing = builder.rpcTracing;
        this.grpcPropagationFormatEnabled = builder.grpcPropagationFormatEnabled;
        this.propagation = this.grpcPropagationFormatEnabled ? GrpcPropagation.create((Propagation<String>)this.rpcTracing.tracing().propagation()) : this.rpcTracing.tracing().propagation();
        this.nameToKey = GrpcPropagation.nameToKey(this.propagation);
        this.clientMessageProcessor = builder.clientMessageProcessor;
        this.serverMessageProcessor = builder.serverMessageProcessor;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public final ClientInterceptor newClientInterceptor() {
        return new TracingClientInterceptor(this);
    }

    public ServerInterceptor newServerInterceptor() {
        return new TracingServerInterceptor(this);
    }

    public static final class Builder {
        RpcTracing rpcTracing;
        boolean grpcPropagationFormatEnabled = false;
        MessageProcessor clientMessageProcessor = MessageProcessor.NOOP;
        MessageProcessor serverMessageProcessor = MessageProcessor.NOOP;

        Builder(RpcTracing rpcTracing) {
            if (rpcTracing == null) {
                throw new NullPointerException("rpcTracing == null");
            }
            this.rpcTracing = rpcTracing;
        }

        Builder(GrpcTracing grpcTracing) {
            this.rpcTracing = grpcTracing.rpcTracing;
            this.clientMessageProcessor = grpcTracing.clientMessageProcessor;
            this.serverMessageProcessor = grpcTracing.serverMessageProcessor;
        }

        @Deprecated
        public Builder clientParser(GrpcClientParser clientParser) {
            if (clientParser == null) {
                throw new NullPointerException("clientParser == null");
            }
            this.clientMessageProcessor = clientParser;
            this.rpcTracing = this.rpcTracing.toBuilder().clientRequestParser((RpcRequestParser)clientParser).clientResponseParser((RpcResponseParser)clientParser).build();
            return this;
        }

        @Deprecated
        public Builder serverParser(GrpcServerParser serverParser) {
            if (serverParser == null) {
                throw new NullPointerException("serverParser == null");
            }
            this.serverMessageProcessor = serverParser;
            this.rpcTracing = this.rpcTracing.toBuilder().serverRequestParser((RpcRequestParser)serverParser).serverResponseParser((RpcResponseParser)serverParser).build();
            return this;
        }

        public Builder grpcPropagationFormatEnabled(boolean grpcPropagationFormatEnabled) {
            this.grpcPropagationFormatEnabled = grpcPropagationFormatEnabled;
            return this;
        }

        public GrpcTracing build() {
            return new GrpcTracing(this);
        }
    }
}

