/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.NoopSpanCustomizer;
import brave.Span;
import brave.SpanCustomizer;
import brave.grpc.GrpcServerRequest;
import brave.grpc.GrpcServerResponse;
import brave.grpc.GrpcTracing;
import brave.grpc.MessageProcessor;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.rpc.RpcServerHandler;
import brave.rpc.RpcServerRequest;
import brave.rpc.RpcServerResponse;
import brave.rpc.RpcTracing;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class TracingServerInterceptor
implements ServerInterceptor {
    final Map<String, Metadata.Key<String>> nameToKey;
    final CurrentTraceContext currentTraceContext;
    final RpcServerHandler handler;
    final boolean grpcPropagationFormatEnabled;
    final MessageProcessor messageProcessor;

    TracingServerInterceptor(GrpcTracing grpcTracing) {
        this.nameToKey = grpcTracing.nameToKey;
        this.currentTraceContext = grpcTracing.rpcTracing.tracing().currentTraceContext();
        this.handler = RpcServerHandler.create((RpcTracing)grpcTracing.rpcTracing);
        this.grpcPropagationFormatEnabled = grpcTracing.grpcPropagationFormatEnabled;
        this.messageProcessor = grpcTracing.serverMessageProcessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        GrpcServerRequest request = new GrpcServerRequest(this.nameToKey, call, headers);
        Span span = this.handler.handleReceive((RpcServerRequest)request);
        AtomicReference<Span> spanRef = new AtomicReference<Span>(span);
        try {
            ServerCall.Listener result;
            CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());
            try {
                result = next.startCall(new TracingServerCall<ReqT, RespT>(call, span, spanRef, request), headers);
                if (scope == null) return new TracingServerCallListener(result, span, spanRef, request);
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
            return new TracingServerCallListener(result, span, spanRef, request);
        }
        catch (Throwable e) {
            spanRef.set(null);
            if (span == null) throw e;
            span.error(e).finish();
            throw e;
        }
    }

    final class TracingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        final TraceContext context;
        final AtomicReference<Span> spanRef;
        final GrpcServerRequest request;
        final Metadata headers;

        TracingServerCall(ServerCall<ReqT, RespT> delegate, Span span, AtomicReference<Span> spanRef, GrpcServerRequest request) {
            super(delegate);
            this.headers = new Metadata();
            this.context = span.context();
            this.spanRef = spanRef;
            this.request = request;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void request(int numMessages) {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().request(numMessages);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void sendHeaders(Metadata headers) {
            block4: {
                CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
                try {
                    this.delegate().sendHeaders(headers);
                    if (scope == null) break block4;
                }
                catch (Throwable throwable) {
                    if (scope == null) throw throwable;
                    try {
                        scope.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                scope.close();
            }
            this.headers.merge(headers);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void sendMessage(RespT message) {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().sendMessage(message);
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingServerInterceptor.this.messageProcessor.onMessageSent(message, (SpanCustomizer)customizer);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close(Status status, Metadata trailers) {
            GrpcServerResponse response = new GrpcServerResponse(this.request, this.headers, status, trailers);
            Span span = this.spanRef.getAndSet(null);
            if (span != null) {
                TracingServerInterceptor.this.handler.handleSend((RpcServerResponse)response, span);
            }
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().close(status, trailers);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }
    }

    final class TracingServerCallListener<RespT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<RespT> {
        final TraceContext context;
        final AtomicReference<Span> spanRef;
        final GrpcServerRequest request;

        TracingServerCallListener(ServerCall.Listener<RespT> delegate, Span span, AtomicReference<Span> spanRef, GrpcServerRequest request) {
            super(delegate);
            this.context = span.context();
            this.spanRef = spanRef;
            this.request = request;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onMessage(RespT message) {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onMessage(message);
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingServerInterceptor.this.messageProcessor.onMessageReceived(message, (SpanCustomizer)customizer);
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onHalfClose() {
            try {
                CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
                try {
                    this.delegate().onHalfClose();
                    if (scope == null) return;
                }
                catch (Throwable throwable) {
                    if (scope == null) throw throwable;
                    try {
                        scope.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                scope.close();
                return;
            }
            catch (Throwable e) {
                Span span = this.spanRef.getAndSet(null);
                if (span == null) throw e;
                span.error(e).finish();
                throw e;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onCancel() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onCancel();
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onComplete() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onComplete();
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onReady() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            try {
                this.delegate().onReady();
                if (scope == null) return;
            }
            catch (Throwable throwable) {
                if (scope == null) throw throwable;
                try {
                    scope.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            scope.close();
        }
    }
}

