/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.NoopSpanCustomizer;
import brave.Span;
import brave.SpanCustomizer;
import brave.grpc.GrpcClientRequest;
import brave.grpc.GrpcClientResponse;
import brave.grpc.GrpcTracing;
import brave.grpc.MessageProcessor;
import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.rpc.RpcClientHandler;
import brave.rpc.RpcClientRequest;
import brave.rpc.RpcClientResponse;
import brave.rpc.RpcTracing;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class TracingClientInterceptor
implements ClientInterceptor {
    final Map<String, Metadata.Key<String>> nameToKey;
    final CurrentTraceContext currentTraceContext;
    final RpcClientHandler handler;
    final MessageProcessor messageProcessor;

    TracingClientInterceptor(GrpcTracing grpcTracing) {
        this.nameToKey = grpcTracing.nameToKey;
        this.currentTraceContext = grpcTracing.rpcTracing.tracing().currentTraceContext();
        this.handler = RpcClientHandler.create((RpcTracing)grpcTracing.rpcTracing);
        this.messageProcessor = grpcTracing.clientMessageProcessor;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new TracingClientCall<ReqT, RespT>(method, callOptions, this.currentTraceContext.get(), next.newCall(method, callOptions));
    }

    CurrentTraceContext.Scope maybeScopeClientOrInvocationContext(AtomicReference<Span> spanRef, @Nullable TraceContext invocationContext) {
        Span span = spanRef.get();
        TraceContext context = span != null ? span.context() : invocationContext;
        return this.currentTraceContext.maybeScope(context);
    }

    final class TracingClientCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        @Nullable
        final TraceContext invocationContext;
        final AtomicReference<Span> spanRef;
        final GrpcClientRequest request;
        final Metadata headers;

        TracingClientCallListener(@Nullable ClientCall.Listener<RespT> delegate, TraceContext invocationContext, AtomicReference<Span> spanRef, GrpcClientRequest request) {
            super(delegate);
            this.headers = new Metadata();
            this.invocationContext = invocationContext;
            this.spanRef = spanRef;
            this.request = request;
        }

        public void onReady() {
            try (CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);){
                this.delegate().onReady();
            }
        }

        public void onHeaders(Metadata headers) {
            this.headers.merge(headers);
            try (CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate().onHeaders(headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(RespT message) {
            try (CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(this.invocationContext);){
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingClientInterceptor.this.messageProcessor.onMessageReceived(message, (SpanCustomizer)customizer);
                this.delegate().onMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Status status, Metadata trailers) {
            GrpcClientResponse response = new GrpcClientResponse(this.request, this.headers, status, trailers);
            Span span = this.spanRef.getAndSet(null);
            if (span != null) {
                TracingClientInterceptor.this.handler.handleReceive((RpcClientResponse)response, span);
            }
            try (CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(this.invocationContext);){
                this.delegate().onClose(status, trailers);
            }
        }
    }

    final class TracingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        final MethodDescriptor<ReqT, RespT> method;
        final CallOptions callOptions;
        final TraceContext invocationContext;
        final AtomicReference<Span> spanRef;

        TracingClientCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, TraceContext invocationContext, ClientCall<ReqT, RespT> call) {
            super(call);
            this.spanRef = new AtomicReference();
            this.method = method;
            this.callOptions = callOptions;
            this.invocationContext = invocationContext;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            GrpcClientRequest request = new GrpcClientRequest(TracingClientInterceptor.this.nameToKey, this.method, this.callOptions, this.delegate(), headers);
            Span span = TracingClientInterceptor.this.handler.handleSendWithParent((RpcClientRequest)request, this.invocationContext);
            this.spanRef.set(span);
            responseListener = new TracingClientCallListener<RespT>(responseListener, this.invocationContext, this.spanRef, request);
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.currentTraceContext.maybeScope(span.context());
            Throwable error = null;
            try {
                super.start(responseListener, headers);
            }
            catch (RuntimeException e) {
                error = e;
                throw e;
            }
            catch (Error e) {
                Throwables.propagateIfFatal((Throwable)e);
                error = e;
                throw e;
            }
            finally {
                if (error != null) {
                    this.spanRef.set(null);
                    if (span != null) {
                        span.error(error).finish();
                    }
                }
                scope.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(@Nullable String message, @Nullable Throwable cause) {
            try (CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);){
                this.delegate().cancel(message, cause);
            }
        }

        public void halfClose() {
            CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);
            Throwable error = null;
            try {
                this.delegate().halfClose();
            }
            catch (RuntimeException e) {
                error = e;
                throw e;
            }
            catch (Error e) {
                Throwables.propagateIfFatal((Throwable)e);
                error = e;
                throw e;
            }
            finally {
                Span span;
                if (error != null && (span = (Span)this.spanRef.getAndSet(null)) != null) {
                    span.error(error).finish();
                }
                scope.close();
            }
        }

        public void request(int numMessages) {
            try (CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);){
                this.delegate().request(numMessages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(ReqT message) {
            try (CurrentTraceContext.Scope scope = TracingClientInterceptor.this.maybeScopeClientOrInvocationContext(this.spanRef, this.invocationContext);){
                this.delegate().sendMessage(message);
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingClientInterceptor.this.messageProcessor.onMessageSent(message, (SpanCustomizer)customizer);
            }
        }
    }
}

