/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.NoopSpanCustomizer;
import brave.Span;
import brave.SpanCustomizer;
import brave.grpc.GrpcServerRequest;
import brave.grpc.GrpcServerResponse;
import brave.grpc.GrpcTracing;
import brave.grpc.MessageProcessor;
import brave.internal.Throwables;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.rpc.RpcServerHandler;
import brave.rpc.RpcServerRequest;
import brave.rpc.RpcServerResponse;
import brave.rpc.RpcTracing;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

final class TracingServerInterceptor
implements ServerInterceptor {
    final Map<String, Metadata.Key<String>> nameToKey;
    final CurrentTraceContext currentTraceContext;
    final RpcServerHandler handler;
    final boolean grpcPropagationFormatEnabled;
    final MessageProcessor messageProcessor;

    TracingServerInterceptor(GrpcTracing grpcTracing) {
        this.nameToKey = grpcTracing.nameToKey;
        this.currentTraceContext = grpcTracing.rpcTracing.tracing().currentTraceContext();
        this.handler = RpcServerHandler.create((RpcTracing)grpcTracing.rpcTracing);
        this.grpcPropagationFormatEnabled = grpcTracing.grpcPropagationFormatEnabled;
        this.messageProcessor = grpcTracing.serverMessageProcessor;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall.Listener result;
        GrpcServerRequest request = new GrpcServerRequest(this.nameToKey, call, headers);
        Span span = this.handler.handleReceive((RpcServerRequest)request);
        AtomicReference<Span> spanRef = new AtomicReference<Span>(span);
        Throwable error = null;
        CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());
        try {
            result = next.startCall(new TracingServerCall<ReqT, RespT>(call, span, spanRef, request), headers);
        }
        catch (RuntimeException e) {
            error = e;
            throw e;
        }
        catch (Error e) {
            Throwables.propagateIfFatal((Throwable)e);
            error = e;
            throw e;
        }
        finally {
            if (error != null) {
                spanRef.set(null);
                if (span != null) {
                    span.error(error).finish();
                }
            }
            scope.close();
        }
        return new TracingServerCallListener(result, span, spanRef, request);
    }

    final class TracingServerCallListener<RespT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<RespT> {
        final TraceContext context;
        final AtomicReference<Span> spanRef;
        final GrpcServerRequest request;

        TracingServerCallListener(ServerCall.Listener<RespT> delegate, Span span, AtomicReference<Span> spanRef, GrpcServerRequest request) {
            super(delegate);
            this.context = span.context();
            this.spanRef = spanRef;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(RespT message) {
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().onMessage(message);
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingServerInterceptor.this.messageProcessor.onMessageReceived(message, (SpanCustomizer)customizer);
            }
        }

        public void onHalfClose() {
            CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);
            Throwable error = null;
            try {
                this.delegate().onHalfClose();
            }
            catch (RuntimeException e) {
                error = e;
                throw e;
            }
            catch (Error e) {
                Throwables.propagateIfFatal((Throwable)e);
                error = e;
                throw e;
            }
            finally {
                Span span;
                if (error != null && (span = (Span)this.spanRef.getAndSet(null)) != null) {
                    span.error(error).finish();
                }
                scope.close();
            }
        }

        public void onCancel() {
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().onCancel();
            }
        }

        public void onComplete() {
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().onComplete();
            }
        }

        public void onReady() {
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().onReady();
            }
        }
    }

    final class TracingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        final TraceContext context;
        final AtomicReference<Span> spanRef;
        final GrpcServerRequest request;
        final Metadata headers;

        TracingServerCall(ServerCall<ReqT, RespT> delegate, Span span, AtomicReference<Span> spanRef, GrpcServerRequest request) {
            super(delegate);
            this.headers = new Metadata();
            this.context = span.context();
            this.spanRef = spanRef;
            this.request = request;
        }

        public void request(int numMessages) {
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().request(numMessages);
            }
        }

        public void sendHeaders(Metadata headers) {
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().sendHeaders(headers);
            }
            this.headers.merge(headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(RespT message) {
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().sendMessage(message);
                Span span = this.spanRef.get();
                NoopSpanCustomizer customizer = span != null ? span.customizer() : NoopSpanCustomizer.INSTANCE;
                TracingServerInterceptor.this.messageProcessor.onMessageSent(message, (SpanCustomizer)customizer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(Status status, Metadata trailers) {
            GrpcServerResponse response = new GrpcServerResponse(this.request, this.headers, status, trailers);
            Span span = this.spanRef.getAndSet(null);
            if (span != null) {
                TracingServerInterceptor.this.handler.handleSend((RpcServerResponse)response, span);
            }
            try (CurrentTraceContext.Scope scope = TracingServerInterceptor.this.currentTraceContext.maybeScope(this.context);){
                this.delegate().close(status, trailers);
            }
        }
    }
}

