/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.test.http.ITHttpClient;
import brave.test.util.AssertableCallback;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import okhttp3.mockwebserver.MockResponse;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class ITHttpAsyncClient<C>
extends ITHttpClient<C> {
    protected abstract void get(C var1, String var2, BiConsumer<Integer, Throwable> var3);

    @Test
    public void usesParentFromInvocationTime() {
        this.server.enqueue(new MockResponse().setBodyDelay(300L, TimeUnit.MILLISECONDS));
        this.server.enqueue(new MockResponse());
        AssertableCallback items1 = new AssertableCallback();
        AssertableCallback items2 = new AssertableCallback();
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(parent);){
            this.get(this.client, "/items/1", (BiConsumer<Integer, Throwable>)items1);
            this.get(this.client, "/items/2", (BiConsumer<Integer, Throwable>)items2);
        }
        scope = this.currentTraceContext.newScope(null);
        try {
            items1.join();
            items2.join();
            for (int i = 0; i < 2; ++i) {
                TraceContext extracted = this.extract(this.takeRequest());
                this.assertChildOf(extracted, parent);
            }
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
        for (int i = 0; i < 2; ++i) {
            this.assertChildOf(this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT), parent);
        }
    }

    @Test
    public void callbackContextIsFromInvocationTime() {
        this.server.enqueue(new MockResponse());
        AssertableCallback callback = new AssertableCallback();
        AtomicReference invocationContext = new AtomicReference();
        callback.setListener(() -> invocationContext.set(this.currentTraceContext.get()));
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        try (CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(parent);){
            this.get(this.client, "/foo", (BiConsumer<Integer, Throwable>)callback);
        }
        callback.join();
        Assertions.assertThat((Object)((TraceContext)invocationContext.get())).isSameAs((Object)parent);
        this.assertChildOf(this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT), parent);
    }

    @Test
    public void callbackContextIsFromInvocationTime_root() {
        this.server.enqueue(new MockResponse());
        AssertableCallback callback = new AssertableCallback();
        AtomicReference invocationContext = new AtomicReference();
        callback.setListener(() -> invocationContext.set(this.currentTraceContext.get()));
        this.get(this.client, "/foo", (BiConsumer<Integer, Throwable>)callback);
        callback.join();
        Assertions.assertThat((Object)((TraceContext)invocationContext.get())).isNull();
        Assertions.assertThat((String)this.testSpanHandler.takeRemoteSpan(Span.Kind.CLIENT).parentId()).isNull();
    }

    @Test
    public void addsStatusCodeWhenNotOk_async() {
        AssertableCallback callback = new AssertableCallback();
        int expectedStatusCode = 400;
        this.server.enqueue(new MockResponse().setResponseCode(expectedStatusCode));
        this.get(this.client, "/foo", (BiConsumer<Integer, Throwable>)callback);
        this.takeRequest();
        callback.join();
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpanWithErrorTag(Span.Kind.CLIENT, "400").tags()).containsEntry((Object)"http.status_code", (Object)"400");
    }
}

