/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.Span;
import brave.Tracing;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.http.HttpRequestMatchers;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpRuleSampler;
import brave.http.HttpTags;
import brave.http.HttpTracing;
import brave.propagation.B3SingleFormat;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import brave.sampler.SamplerFunction;
import brave.test.ITRemote;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;

public abstract class ITHttpServer
extends ITRemote {
    public static final IllegalStateException NOT_READY_ISE = new IllegalStateException("not ready"){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    };
    protected OkHttpClient client = new OkHttpClient();
    protected HttpTracing httpTracing = HttpTracing.create((Tracing)this.tracing);
    final HttpRequestParser addHttpUrlTag = (request, context, span) -> {
        HttpRequestParser.DEFAULT.parse(request, context, span);
        HttpTags.URL.tag((Object)request, span);
    };

    @BeforeEach
    protected void setup() throws IOException {
        this.init();
    }

    protected abstract void init() throws IOException;

    protected abstract String url(String var1);

    @Test
    protected void reusesPropagatedSpanId() throws IOException {
        String path = "/foo";
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        this.get(new Request.Builder().url(this.url(path)).header("b3", B3SingleFormat.writeB3SingleFormat((TraceContext)parent)).build());
        this.assertSameIds(this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER), parent);
    }

    @Test
    protected void createsChildWhenJoinDisabled() throws IOException {
        this.tracing = this.tracingBuilder(Sampler.NEVER_SAMPLE).supportsJoin(false).build();
        this.httpTracing = HttpTracing.create((Tracing)this.tracing);
        this.init();
        String path = "/foo";
        TraceContext parent = this.newTraceContext(SamplingFlags.SAMPLED);
        this.get(new Request.Builder().url(this.url(path)).header("b3", B3SingleFormat.writeB3SingleFormat((TraceContext)parent)).build());
        MutableSpan span = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        this.assertChildOf(span, parent);
        Assertions.assertThat((String)span.id()).isNotEqualTo((Object)parent.spanIdString());
    }

    @Test
    protected void readsBaggage_newTrace() throws IOException {
        this.readsBaggage(new Request.Builder());
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void readsBaggage_unsampled() throws IOException {
        this.readsBaggage(new Request.Builder().header("X-B3-Sampled", "0"));
    }

    @Test
    protected void readsBaggage_existingTrace() throws IOException {
        String traceId = "463ac35c9f6413ad";
        this.readsBaggage(new Request.Builder().header("X-B3-TraceId", traceId).header("X-B3-SpanId", traceId));
        MutableSpan span = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        Assertions.assertThat((String)span.traceId()).isEqualTo(traceId);
        Assertions.assertThat((String)span.id()).isEqualTo(traceId);
    }

    void readsBaggage(Request.Builder builder) throws IOException {
        Request request = builder.url(this.url("/baggage")).header("user_id", "joey").build();
        Response response = this.get(request);
        Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
        Assertions.assertThat((String)response.body().source().readUtf8()).isEqualTo("joey");
    }

    @Test
    protected void samplingDisabled() throws IOException {
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.NEVER_SAMPLE).build());
        this.init();
        this.get("/foo");
    }

    @Test
    protected void customSampler() throws IOException {
        String path = "/foo";
        HttpRuleSampler sampler = HttpRuleSampler.newBuilder().putRule(HttpRequestMatchers.pathStartsWith((String)path), Sampler.NEVER_SAMPLE).build();
        this.httpTracing = this.httpTracing.toBuilder().serverSampler((SamplerFunction)sampler).build();
        this.init();
        Request request = new Request.Builder().url(this.url(path)).build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
        }
    }

    @Test
    protected void async() throws IOException {
        Response response = this.get("/async");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)response.isSuccessful()).withFailMessage("not successful: " + response, new Object[0])).isTrue();
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void createsChildSpan() throws IOException {
        this.get("/child");
        MutableSpan child = this.testSpanHandler.takeLocalSpan();
        MutableSpan server = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        this.assertChildOf(child, server);
        Assertions.assertThat((String)child.name()).isEqualTo("child");
    }

    @Test
    protected void childCompletesBeforeServer() throws IOException {
        this.get("/child");
        MutableSpan child = this.testSpanHandler.takeLocalSpan();
        MutableSpan server = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        this.assertChildOf(child, server);
        Assertions.assertThat((String)child.name()).isEqualTo("child");
        this.assertSpanInInterval(child, server.startTimestamp(), server.finishTimestamp());
    }

    @Test
    protected void reportsClientAddress() throws IOException {
        this.get("/foo");
        Assertions.assertThat((String)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).remoteIp()).isNotNull();
    }

    @Test
    protected void reportsClientAddress_XForwardedFor() throws IOException {
        this.get(new Request.Builder().url(this.url("/foo")).header("X-Forwarded-For", "1.2.3.4").build());
        Assertions.assertThat((String)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).remoteIp()).isEqualTo("1.2.3.4");
    }

    @Test
    protected void reportsServerKindToZipkin() throws IOException {
        this.get("/foo");
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void defaultSpanNameIsMethodNameOrRoute() throws IOException {
        this.get("/foo");
        MutableSpan span = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        if (!span.name().equals("GET")) {
            Assertions.assertThat((String)span.name()).isEqualTo("GET /foo");
        }
    }

    @Test
    protected void readsRequestAtResponseTime() throws IOException {
        this.httpTracing = this.httpTracing.toBuilder().serverResponseParser((response, context, span) -> HttpTags.URL.tag((Object)response.request(), span)).build();
        this.init();
        String uri = "/foo?z=2&yAA=1";
        this.get(uri);
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).tags()).containsEntry((Object)"http.url", (Object)this.url(uri));
    }

    @Test
    protected void supportsPortableCustomization() throws IOException {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser((request, context, span) -> {
            span.name(request.method().toLowerCase() + " " + request.path());
            HttpTags.URL.tag((Object)request, span);
            span.tag("request_customizer.is_span", (span instanceof Span) + "");
        }).serverResponseParser((response, context, span) -> {
            HttpResponseParser.DEFAULT.parse(response, context, span);
            span.tag("response_customizer.is_span", (span instanceof Span) + "");
        }).build();
        this.init();
        String uri = "/foo?z=2&yAA=1";
        this.get(uri);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).tags()).containsEntry((Object)"http.url", (Object)this.url(uri))).containsEntry((Object)"request_customizer.is_span", (Object)"false")).containsEntry((Object)"response_customizer.is_span", (Object)"false");
    }

    @Test
    protected void httpRoute() throws IOException {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser(this.addHttpUrlTag).build();
        this.init();
        this.routeBasedRequestNameIncludesPathPrefix("/items");
    }

    @Test
    protected void httpRoute_nested() throws IOException {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser(this.addHttpUrlTag).build();
        this.init();
        this.routeBasedRequestNameIncludesPathPrefix("/nested/items");
    }

    @Test
    protected void httpRoute_async() throws IOException {
        this.httpTracing = this.httpTracing.toBuilder().serverRequestParser(this.addHttpUrlTag).build();
        this.init();
        this.routeBasedRequestNameIncludesPathPrefix("/async_items");
    }

    private void routeBasedRequestNameIncludesPathPrefix(String prefix) throws IOException {
        Response request1 = this.get(prefix + "/1?foo");
        Response request2 = this.get(prefix + "/2?bar");
        Assertions.assertThat((boolean)request1.isSuccessful()).isTrue();
        Assertions.assertThat((boolean)request2.isSuccessful()).isTrue();
        Assertions.assertThat((String)request1.body().string()).isEqualTo("1");
        Assertions.assertThat((String)request2.body().string()).isEqualTo("2");
        MutableSpan span1 = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        MutableSpan span2 = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)span1.tags()).containsEntry((Object)"http.method", (Object)"GET")).containsEntry((Object)"http.path", (Object)(prefix + "/1"))).containsEntry((Object)"http.url", (Object)this.url(prefix + "/1?foo"));
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)span2.tags()).containsEntry((Object)"http.method", (Object)"GET")).containsEntry((Object)"http.path", (Object)(prefix + "/2"))).containsEntry((Object)"http.url", (Object)this.url(prefix + "/2?bar"));
        LinkedHashSet<String> routeBasedNames = new LinkedHashSet<String>(Arrays.asList(span1.name(), span2.name()));
        Assertions.assertThat(routeBasedNames).hasSize(1);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((String)routeBasedNames.iterator().next())).startsWith((CharSequence)("GET " + prefix))).doesNotEndWith((CharSequence)"/")).doesNotContain(new CharSequence[]{"//"});
    }

    @Test
    protected void notFound() throws IOException {
        Assertions.assertThat((int)this.call("GET", "/foo/bark").code()).isEqualTo(404);
        MutableSpan span = this.testSpanHandler.takeRemoteSpanWithErrorTag(Span.Kind.SERVER, "404");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)span.tags()).hasSize(4)).containsEntry((Object)"http.method", (Object)"GET")).containsEntry((Object)"http.path", (Object)"/foo/bark")).containsEntry((Object)"http.status_code", (Object)"404");
        String name = span.name();
        if (name != null && !"GET".equals(name)) {
            Assertions.assertThat((String)name).isEqualTo("GET not_found");
        }
    }

    @Test
    protected void options() throws IOException {
        Assertions.assertThat((boolean)this.call("OPTIONS", "/").isSuccessful()).isTrue();
        MutableSpan span = this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
        ((MapAssert)Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.method", (Object)"OPTIONS")).containsEntry((Object)"http.path", (Object)"/");
        String name = span.name();
        if (name != null && !"OPTIONS".equals(name)) {
            Assertions.assertThat((String)name).isEqualTo("OPTIONS /");
        }
    }

    @Test
    protected void addsStatusCode_badRequest() throws IOException {
        try {
            this.get("/badrequest");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpanWithErrorTag(Span.Kind.SERVER, "400").tags()).containsEntry((Object)"error", (Object)"400");
    }

    @Test
    protected void httpPathTagExcludesQueryParams() throws IOException {
        this.get("/foo?z=2&yAA=1");
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).tags()).containsEntry((Object)"http.path", (Object)"/foo");
    }

    @Test
    protected void httpStatusCodeTagMatchesResponse_onUncaughtException() throws IOException {
        this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exception");
    }

    @Test
    protected void httpStatusCodeTagMatchesResponse_onUncaughtException_async() throws IOException {
        this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exceptionAsync");
    }

    @Test
    protected void httpStatusCodeSettable_onUncaughtException() throws IOException {
        Assertions.assertThat((int)this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exception").code()).isEqualTo(503);
    }

    @Test
    protected void httpStatusCodeSettable_onUncaughtException_async() throws IOException {
        Assertions.assertThat((int)this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exceptionAsync").code()).isEqualTo(503);
    }

    protected Response httpStatusCodeTagMatchesResponse_onUncaughtException(String path, String errorMessage) throws IOException {
        Response response = this.get(path);
        String responseCode = String.valueOf(response.code());
        MutableSpan span = this.testSpanHandler.takeRemoteSpanWithErrorMessage(Span.Kind.SERVER, errorMessage);
        Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.status_code", (Object)responseCode);
        return response;
    }

    protected Response httpStatusCodeTagMatchesResponse_onUncaughtException(String path) throws IOException {
        Response response = this.get(path);
        MutableSpan span = this.testSpanHandler.takeRemoteSpanWithError(Span.Kind.SERVER);
        Assertions.assertThat((Map)span.tags()).containsEntry((Object)"http.status_code", (Object)String.valueOf(response.code()));
        return response;
    }

    @Test
    protected void setsErrorAndHttpStatusOnUncaughtException() throws IOException {
        this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exception", ".*not ready");
    }

    @Test
    protected void setsErrorAndHttpStatusOnUncaughtException_async() throws IOException {
        this.httpStatusCodeTagMatchesResponse_onUncaughtException("/exceptionAsync", ".*not ready");
    }

    @Test
    protected void spanHandlerSeesError() throws IOException {
        this.spanHandlerSeesError("/exception");
    }

    @Test
    protected void spanHandlerSeesError_async() throws IOException {
        this.spanHandlerSeesError("/exceptionAsync");
    }

    void spanHandlerSeesError(String path) throws IOException {
        final ConcurrentLinkedDeque caughtThrowables = new ConcurrentLinkedDeque();
        this.httpTracing = HttpTracing.create((Tracing)this.tracingBuilder(Sampler.ALWAYS_SAMPLE).clearSpanHandlers().addSpanHandler(new SpanHandler(){

            public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
                Throwable error = span.error();
                if (error != null) {
                    caughtThrowables.add(error);
                } else {
                    caughtThrowables.add(new RuntimeException("Unexpected additional call to end"));
                }
                return true;
            }
        }).addSpanHandler((SpanHandler)this.testSpanHandler).build());
        this.init();
        this.httpStatusCodeTagMatchesResponse_onUncaughtException(path, ".*not ready");
        ((AbstractCollectionAssert)Assertions.assertThat(caughtThrowables).withFailMessage("Span finished with error, but caughtThrowables empty", new Object[0])).isNotEmpty();
        if (caughtThrowables.size() > 1) {
            for (Throwable throwable : caughtThrowables) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "multiple calls to finish", throwable);
            }
            Assertions.assertThat(caughtThrowables).hasSize(1);
        }
    }

    protected Response get(String path) throws IOException {
        return this.get(new Request.Builder().url(this.url(path)).build());
    }

    protected Response get(Request request) throws IOException {
        Response response = this.call(request);
        if (response.code() == 404) {
            this.testSpanHandler.ignoreAnySpans();
            throw new TestAbortedException(response.request().url().encodedPath() + " not supported");
        }
        return response;
    }

    Response call(String method, String path) throws IOException {
        return this.call(new Request.Builder().method(method, null).url(this.url(path)).build());
    }

    Response call(Request request) throws IOException {
        request = request.newBuilder().header("test", this.testName).build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody toReturn;
            if (response.body() == null) {
                Response response2 = response;
                return response2;
            }
            try (ResponseBody body = response.body();){
                Buffer buffer = new Buffer();
                body.source().readAll((Sink)buffer);
                toReturn = ResponseBody.create((MediaType)body.contentType(), (long)body.contentLength(), (BufferedSource)buffer);
            }
            Response response3 = response.newBuilder().body(toReturn).build();
            return response3;
        }
    }
}

