/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpSampler;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import zipkin2.Endpoint;

public final class HttpServerHandler<Req, Resp> {
    final Tracer tracer;
    final HttpSampler sampler;
    final HttpServerParser parser;
    final HttpServerAdapter<Req, Resp> adapter;

    public static <Req, Resp> HttpServerHandler<Req, Resp> create(HttpTracing httpTracing, HttpServerAdapter<Req, Resp> adapter) {
        return new HttpServerHandler<Req, Resp>(httpTracing.tracing().tracer(), httpTracing.serverSampler(), httpTracing.serverParser(), adapter);
    }

    HttpServerHandler(Tracer tracer, HttpSampler sampler, HttpServerParser parser, HttpServerAdapter<Req, Resp> adapter) {
        this.tracer = tracer;
        this.sampler = sampler;
        this.parser = parser;
        this.adapter = adapter;
    }

    public Span handleReceive(TraceContext.Extractor<Req> extractor, Req request) {
        return this.handleReceive(extractor, request, request);
    }

    public <C> Span handleReceive(TraceContext.Extractor<C> extractor, C carrier, Req request) {
        Span span = this.nextSpan(extractor.extract(carrier), request);
        if (span.isNoop()) {
            return span;
        }
        span.kind(Span.Kind.SERVER);
        this.parseRequest(request, span);
        return span.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseRequest(Req request, Span span) {
        if (span.isNoop()) {
            return;
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.parser.request(this.adapter, request, span.customizer());
        }
        finally {
            ws.close();
        }
        Endpoint.Builder remoteEndpoint = Endpoint.newBuilder();
        if (this.adapter.parseClientAddress(request, remoteEndpoint)) {
            span.remoteEndpoint(remoteEndpoint.build());
        }
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, Req request) {
        if (extracted.sampled() == null) {
            extracted = extracted.sampled(this.sampler.trySample(this.adapter, request));
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSend(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (span.isNoop()) {
            return;
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        try {
            this.parser.response(this.adapter, response, error, span.customizer());
        }
        finally {
            ws.close();
            span.finish();
        }
    }
}

