/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientAdapters;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpHandler;
import brave.http.HttpRequest;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import brave.sampler.SamplerFunction;

public final class HttpClientHandler<Req, Resp>
extends HttpHandler {
    final Tracer tracer;
    @Deprecated
    @Nullable
    final HttpClientAdapter<Req, Resp> adapter;
    final Sampler sampler;
    final SamplerFunction<HttpRequest> httpSampler;
    @Nullable
    final String serverName;
    final TraceContext.Injector<HttpClientRequest> defaultInjector;

    public static HttpClientHandler<HttpClientRequest, HttpClientResponse> create(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        return new HttpClientHandler<HttpClientRequest, HttpClientResponse>(httpTracing, null);
    }

    @Deprecated
    public static <Req, Resp> HttpClientHandler<Req, Resp> create(HttpTracing httpTracing, HttpClientAdapter<Req, Resp> adapter) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        if (adapter == null) {
            throw new NullPointerException("adapter == null");
        }
        return new HttpClientHandler<Req, Resp>(httpTracing, adapter);
    }

    HttpClientHandler(HttpTracing httpTracing, @Deprecated HttpClientAdapter<Req, Resp> adapter) {
        super(httpTracing.clientRequestParser(), httpTracing.clientResponseParser());
        this.adapter = adapter;
        this.tracer = httpTracing.tracing().tracer();
        this.sampler = httpTracing.tracing().sampler();
        this.httpSampler = httpTracing.clientRequestSampler();
        this.serverName = !"".equals(httpTracing.serverName()) ? httpTracing.serverName() : null;
        this.defaultInjector = httpTracing.tracing().propagation().injector(HttpClientRequest.SETTER);
    }

    public Span handleSend(HttpClientRequest request) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        return this.handleSend(request, this.tracer.nextSpan(this.httpSampler, (Object)request));
    }

    public Span handleSendWithParent(HttpClientRequest request, @Nullable TraceContext parent) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        return this.handleSend(request, this.tracer.nextSpanWithParent(this.httpSampler, (Object)request, parent));
    }

    public Span handleSend(HttpClientRequest request, Span span) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        this.defaultInjector.inject(span.context(), (Object)request);
        return this.handleStart(request, span);
    }

    @Override
    void parseRequest(HttpRequest request, Span span) {
        if (this.serverName != null) {
            span.remoteServiceName(this.serverName);
        }
        this.requestParser.parse(request, span.context(), span.customizer());
    }

    @Deprecated
    public Span handleSend(TraceContext.Injector<Req> injector, Req request) {
        return this.handleSend(injector, request, request);
    }

    @Deprecated
    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request) {
        return this.handleSend(injector, carrier, request, this.nextSpan(request));
    }

    @Deprecated
    public Span handleSend(TraceContext.Injector<Req> injector, Req request, Span span) {
        return this.handleSend(injector, request, request, span);
    }

    @Deprecated
    public <C> Span handleSend(TraceContext.Injector<C> injector, C carrier, Req request, Span span) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        injector.inject(span.context(), carrier);
        HttpClientAdapters.FromRequestAdapter<Req> clientRequest = request instanceof HttpClientRequest ? (HttpClientAdapters.FromRequestAdapter<Req>)((Object)request) : new HttpClientAdapters.FromRequestAdapter<Req>(this.adapter, request);
        return this.handleStart(clientRequest, span);
    }

    @Deprecated
    public Span nextSpan(Req request) {
        HttpClientAdapters.FromRequestAdapter<Req> clientRequest = request instanceof HttpClientRequest ? (HttpClientAdapters.FromRequestAdapter<Req>)((Object)request) : new HttpClientAdapters.FromRequestAdapter<Req>(this.adapter, request);
        return this.tracer.nextSpan(this.httpSampler, clientRequest);
    }

    public void handleReceive(@Nullable Resp response, @Nullable Throwable error, Span span) {
        HttpClientAdapters.FromResponseAdapter<Resp> clientResponse = response == null || response instanceof HttpClientResponse ? (HttpClientAdapters.FromResponseAdapter<Resp>)((Object)response) : new HttpClientAdapters.FromResponseAdapter<Resp>(this.adapter, response);
        this.handleFinish(clientResponse, error, span);
    }
}

