/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.http.HttpServerAdapter;
import brave.internal.Nullable;
import brave.propagation.Propagation;

public abstract class HttpServerRequest {
    static final Propagation.Getter<HttpServerRequest, String> GETTER = new Propagation.Getter<HttpServerRequest, String>(){

        public String get(HttpServerRequest carrier, String key) {
            return carrier.header(key);
        }

        public String toString() {
            return "HttpServerRequest::header";
        }
    };

    public abstract Object unwrap();

    @Nullable
    public abstract String method();

    @Nullable
    public abstract String path();

    @Nullable
    public abstract String url();

    @Nullable
    public abstract String header(String var1);

    public boolean parseClientIpAndPort(Span span) {
        return false;
    }

    public long startTimestamp() {
        return 0L;
    }

    public String toString() {
        return "HttpServerRequest{" + this.unwrap() + "}";
    }

    static final class Adapter
    extends HttpServerAdapter<Object, Void> {
        final HttpServerRequest delegate;
        final Object unwrapped;

        Adapter(HttpServerRequest delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate == null");
            }
            this.delegate = delegate;
            this.unwrapped = delegate.unwrap();
            if (this.unwrapped == null) {
                throw new NullPointerException("delegate.unwrap() == null");
            }
        }

        @Override
        public final boolean parseClientIpAndPort(Object req, Span span) {
            if (req == this.unwrapped) {
                if (this.parseClientIpFromXForwardedFor(req, span)) {
                    return true;
                }
                return this.delegate.parseClientIpAndPort(span);
            }
            return false;
        }

        @Override
        public final String method(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.method();
            }
            return null;
        }

        @Override
        public final String url(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.url();
            }
            return null;
        }

        @Override
        public final String requestHeader(Object request, String name) {
            if (request == this.unwrapped) {
                return this.delegate.header(name);
            }
            return null;
        }

        @Override
        public final String path(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.path();
            }
            return null;
        }

        @Override
        public final long startTimestamp(Object request) {
            if (request == this.unwrapped) {
                return this.delegate.startTimestamp();
            }
            return 0L;
        }

        @Override
        public final String methodFromResponse(Void response) {
            return null;
        }

        @Override
        public final String route(Void response) {
            return null;
        }

        @Override
        public final int statusCodeAsInt(Void response) {
            return 0;
        }

        @Override
        public final Integer statusCode(Void response) {
            return null;
        }

        @Override
        public final long finishTimestamp(Void response) {
            return 0L;
        }

        public String toString() {
            return this.delegate.toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Adapter)) {
                return false;
            }
            Adapter that = (Adapter)o;
            return this.delegate == that.delegate;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

