/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.http.HttpAdapter;
import brave.http.HttpParser;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;

abstract class HttpHandler {
    final CurrentTraceContext currentTraceContext;
    final HttpParser parser;

    HttpHandler(CurrentTraceContext currentTraceContext, HttpParser parser) {
        this.currentTraceContext = currentTraceContext;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Req> Span handleStart(HttpAdapter<Req, ?> adapter, Req request, Span span) {
        if (span.isNoop()) {
            return span;
        }
        CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());
        try {
            this.parseRequest(adapter, request, span);
        }
        finally {
            ws.close();
        }
        long timestamp = adapter.startTimestamp(request);
        if (timestamp == 0L) {
            span.start();
        } else {
            span.start(timestamp);
        }
        return span;
    }

    abstract <Req> void parseRequest(HttpAdapter<Req, ?> var1, Req var2, Span var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Resp> void handleFinish(HttpAdapter<?, Resp> adapter, @Nullable Resp response, @Nullable Throwable error, Span span) {
        if (span.isNoop()) {
            return;
        }
        long finishTimestamp = response != null ? adapter.finishTimestamp(response) : 0L;
        CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());
        try {
            this.parser.response(adapter, response, error, span.customizer());
        }
        finally {
            if (finishTimestamp == 0L) {
                span.finish();
            } else {
                span.finish(finishTimestamp);
            }
            ws.close();
        }
    }
}

