/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient5;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpRequest;
import brave.http.HttpTracing;
import brave.httpclient5.HttpClientUtils;
import brave.httpclient5.HttpRequestWrapper;
import brave.httpclient5.HttpResponseWrapper;
import brave.internal.Throwables;
import brave.sampler.SamplerFunction;
import java.io.IOException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;

class HandleReceiveHandler
implements ExecChainHandler {
    final Tracer tracer;
    final SamplerFunction<HttpRequest> httpSampler;
    final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

    HandleReceiveHandler(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.httpSampler = httpTracing.clientRequestSampler();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest classicHttpRequest, ExecChain.Scope execChainScope, ExecChain execChain) throws IOException, HttpException {
        HttpHost targetHost = execChainScope.route.getTargetHost();
        HttpRequestWrapper request = new HttpRequestWrapper((org.apache.hc.core5.http.HttpRequest)classicHttpRequest, targetHost);
        Span span = this.tracer.nextSpan(this.httpSampler, (Object)request);
        HttpClientContext clientContext = execChainScope.clientContext;
        clientContext.setAttribute(Span.class.getName(), (Object)span);
        ClassicHttpResponse response = null;
        Throwable error = null;
        try {
            ClassicHttpResponse classicHttpResponse;
            block12: {
                Tracer.SpanInScope scope = this.tracer.withSpanInScope(span);
                try {
                    classicHttpResponse = response = execChain.proceed(classicHttpRequest, execChainScope);
                    if (scope == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        Throwables.propagateIfFatal((Throwable)e);
                        error = e;
                        throw e;
                    }
                }
                scope.close();
            }
            return classicHttpResponse;
        }
        finally {
            if (HttpClientUtils.isLocalCached((HttpContext)clientContext, span)) {
                this.handler.handleSend((HttpClientRequest)request, span);
                span.kind(null);
                clientContext.removeAttribute(Span.class.getName());
            }
            this.handler.handleReceive((HttpClientResponse)new HttpResponseWrapper((HttpResponse)response, request, error), span);
        }
    }
}

