/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient5;

import brave.Tracing;
import brave.http.HttpTracing;
import brave.httpclient5.AsyncHandleSendHandler;
import brave.httpclient5.HandleReceiveHandler;
import brave.httpclient5.HandleSendHandler;
import brave.httpclient5.TraceContextCloseScopeInterceptor;
import brave.httpclient5.TraceContextOpenScopeInterceptor;
import brave.httpclient5.TracingHttpAsyncClient;
import brave.propagation.CurrentTraceContext;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.H2AsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;

public class HttpClient5Tracing {
    final HttpTracing httpTracing;
    final CurrentTraceContext currentTraceContext;
    final TraceContextOpenScopeInterceptor openInterceptor;
    final TraceContextCloseScopeInterceptor closeInterceptor;

    HttpClient5Tracing(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("HttpTracing == null");
        }
        this.httpTracing = httpTracing;
        this.openInterceptor = new TraceContextOpenScopeInterceptor(httpTracing.tracing().currentTraceContext());
        this.closeInterceptor = new TraceContextCloseScopeInterceptor();
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
    }

    public static HttpClient5Tracing newBuilder(Tracing tracing) {
        return new HttpClient5Tracing(HttpTracing.create((Tracing)tracing));
    }

    public static HttpClient5Tracing newBuilder(HttpTracing httpTracing) {
        return new HttpClient5Tracing(httpTracing);
    }

    public CloseableHttpClient build(HttpClientBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("HttpClientBuilder == null");
        }
        builder.addExecInterceptorBefore(ChainElement.MAIN_TRANSPORT.name(), HandleSendHandler.class.getName(), (ExecChainHandler)new HandleSendHandler(this.httpTracing));
        builder.addExecInterceptorBefore(ChainElement.PROTOCOL.name(), HandleReceiveHandler.class.getName(), (ExecChainHandler)new HandleReceiveHandler(this.httpTracing));
        return builder.build();
    }

    public CloseableHttpAsyncClient build(HttpAsyncClientBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("HttpAsyncClientBuilder == null");
        }
        builder.addExecInterceptorBefore(ChainElement.PROTOCOL.name(), AsyncHandleSendHandler.class.getName(), (AsyncExecChainHandler)new AsyncHandleSendHandler(this.httpTracing));
        builder.addRequestInterceptorFirst((HttpRequestInterceptor)this.openInterceptor);
        builder.addRequestInterceptorLast((HttpRequestInterceptor)this.closeInterceptor);
        builder.addResponseInterceptorFirst((HttpResponseInterceptor)this.openInterceptor);
        builder.addResponseInterceptorLast((HttpResponseInterceptor)this.closeInterceptor);
        return new TracingHttpAsyncClient(builder.build(), this.currentTraceContext);
    }

    public CloseableHttpAsyncClient build(H2AsyncClientBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("H2AsyncClientBuilder == null");
        }
        builder.addExecInterceptorBefore(ChainElement.PROTOCOL.name(), AsyncHandleSendHandler.class.getName(), (AsyncExecChainHandler)new AsyncHandleSendHandler(this.httpTracing));
        builder.addRequestInterceptorFirst((HttpRequestInterceptor)this.openInterceptor);
        builder.addRequestInterceptorLast((HttpRequestInterceptor)this.closeInterceptor);
        builder.addResponseInterceptorFirst((HttpResponseInterceptor)this.openInterceptor);
        builder.addResponseInterceptorLast((HttpResponseInterceptor)this.closeInterceptor);
        return new TracingHttpAsyncClient(builder.build(), this.currentTraceContext);
    }
}

