/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient5;

import brave.httpclient5.TraceContextFutureCallback;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.TimeValue;

class TracingHttpAsyncClient
extends CloseableHttpAsyncClient {
    final CloseableHttpAsyncClient delegate;
    final CurrentTraceContext currentTraceContext;

    TracingHttpAsyncClient(CloseableHttpAsyncClient delegate, CurrentTraceContext currentTraceContext) {
        this.delegate = delegate;
        this.currentTraceContext = currentTraceContext;
    }

    public void start() {
        this.delegate.start();
    }

    public IOReactorStatus getStatus() {
        return this.delegate.getStatus();
    }

    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.delegate.awaitShutdown(waitTime);
    }

    public void initiateShutdown() {
        this.delegate.initiateShutdown();
    }

    protected <T> Future<T> doExecute(HttpHost target, AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context, FutureCallback<T> callback) {
        TraceContext invocationContext = this.currentTraceContext.get();
        HttpClientContext clientContext = HttpClientContext.castOrCreate((HttpContext)context);
        if (invocationContext != null) {
            clientContext.setAttribute(TraceContext.class.getName(), (Object)invocationContext);
        }
        if (callback != null && invocationContext != null) {
            callback = new TraceContextFutureCallback<T>(callback, this.currentTraceContext, invocationContext);
        }
        return this.delegate.execute(target, requestProducer, responseConsumer, pushHandlerFactory, (HttpContext)clientContext, callback);
    }

    public void register(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        this.delegate.register(hostname, uriPattern, supplier);
    }

    public void close(CloseMode closeMode) {
        this.delegate.close(closeMode);
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

