/*
 * Decompiled with CFR 0.152.
 */
package brave.jersey.server;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import brave.jersey.server.EventParser;
import brave.jersey.server.SpanCustomizingApplicationEventListener;
import javax.inject.Inject;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

@Provider
public final class TracingApplicationEventListener
implements ApplicationEventListener {
    final Tracer tracer;
    final HttpServerHandler<HttpServerRequest, HttpServerResponse> handler;
    final EventParser parser;

    public static ApplicationEventListener create(HttpTracing httpTracing) {
        return new TracingApplicationEventListener(httpTracing, new EventParser());
    }

    @Inject
    TracingApplicationEventListener(HttpTracing httpTracing, EventParser parser) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpServerHandler.create((HttpTracing)httpTracing);
        this.parser = parser;
    }

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent event) {
        if (event.getType() != RequestEvent.Type.START) {
            return null;
        }
        Span span = this.handler.handleReceive((HttpServerRequest)new ContainerRequestWrapper(event.getContainerRequest()));
        return new TracingRequestEventListener(span, this.tracer.withSpanInScope(span));
    }

    static boolean async(RequestEvent event) {
        return event.getUriInfo().getMatchedResourceMethod().isManagedAsyncDeclared() || event.getUriInfo().getMatchedResourceMethod().isSuspendDeclared();
    }

    static final class ContainerRequestWrapper
    extends HttpServerRequest {
        final ContainerRequest delegate;

        ContainerRequestWrapper(ContainerRequest delegate) {
            this.delegate = delegate;
        }

        public String route() {
            return SpanCustomizingApplicationEventListener.route(this.delegate);
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethod();
        }

        public String path() {
            String result = this.delegate.getPath(false);
            return result.indexOf(47) == 0 ? result : "/" + result;
        }

        public String url() {
            return this.delegate.getUriInfo().getRequestUri().toString();
        }

        public String header(String name) {
            return this.delegate.getHeaderString(name);
        }
    }

    class TracingRequestEventListener
    implements RequestEventListener {
        final Span span;
        volatile Tracer.SpanInScope spanInScope;
        volatile boolean async;

        TracingRequestEventListener(Span span, Tracer.SpanInScope spanInScope) {
            this.span = span;
            this.spanInScope = spanInScope;
        }

        public void onEvent(RequestEvent event) {
            switch (event.getType()) {
                case REQUEST_MATCHED: {
                    TracingApplicationEventListener.this.parser.requestMatched(event, (SpanCustomizer)this.span);
                    this.async = TracingApplicationEventListener.async(event);
                    break;
                }
                case REQUEST_FILTERED: 
                case RESOURCE_METHOD_FINISHED: {
                    Tracer.SpanInScope maybeSpanInScope;
                    if (!this.async || (maybeSpanInScope = this.spanInScope) == null) break;
                    maybeSpanInScope.close();
                    this.spanInScope = null;
                    break;
                }
                case RESOURCE_METHOD_START: {
                    if (!this.async || this.spanInScope != null) break;
                    this.spanInScope = TracingApplicationEventListener.this.tracer.withSpanInScope(this.span);
                    break;
                }
                case FINISHED: {
                    Tracer.SpanInScope maybeSpanInScope;
                    RequestEventWrapper response = new RequestEventWrapper(event);
                    TracingApplicationEventListener.this.handler.handleSend((Object)response, response.error(), this.span);
                    if (this.async || (maybeSpanInScope = this.spanInScope) == null) break;
                    maybeSpanInScope.close();
                    break;
                }
            }
        }
    }

    static final class RequestEventWrapper
    extends HttpServerResponse {
        final RequestEvent event;
        ContainerRequestWrapper request;

        RequestEventWrapper(RequestEvent event) {
            this.event = event;
        }

        public Object unwrap() {
            return this.event;
        }

        public ContainerRequestWrapper request() {
            if (this.request == null) {
                this.request = new ContainerRequestWrapper(this.event.getContainerRequest());
            }
            return this.request;
        }

        public Throwable error() {
            return SpanCustomizingApplicationEventListener.unwrapError(this.event);
        }

        public int statusCode() {
            ContainerResponse response = this.event.getContainerResponse();
            if (response == null) {
                return 0;
            }
            return response.getStatus();
        }
    }
}

