/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.internal.Throwables;
import brave.jakarta.jms.JMSProducerRequest;
import brave.jakarta.jms.MessageConsumerRequest;
import brave.jakarta.jms.MessageParser;
import brave.jakarta.jms.MessageProducerRequest;
import brave.jakarta.jms.MessageProperties;
import brave.jakarta.jms.PropertyFilter;
import brave.jakarta.jms.TracingConnection;
import brave.jakarta.jms.TracingConnectionFactory;
import brave.jakarta.jms.TracingMessageListener;
import brave.jakarta.jms.TracingXAConnection;
import brave.jakarta.jms.TracingXAConnectionFactory;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.QueueConnection;
import jakarta.jms.TopicConnection;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XATopicConnection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class JmsTracing {
    static final String JMS_QUEUE = "jms.queue";
    static final String JMS_TOPIC = "jms.topic";
    static final Propagation.Getter<Message, String> GETTER = new Propagation.Getter<Message, String>(){

        public String get(Message message, String name) {
            return MessageProperties.getPropertyIfString(message, name);
        }

        public String toString() {
            return "Message::getStringProperty";
        }
    };
    final Tracing tracing;
    final Tracer tracer;
    final TraceContext.Extractor<MessageProducerRequest> messageProducerExtractor;
    final TraceContext.Injector<MessageProducerRequest> messageProducerInjector;
    final TraceContext.Extractor<MessageConsumerRequest> messageConsumerExtractor;
    final TraceContext.Injector<MessageConsumerRequest> messageConsumerInjector;
    final TraceContext.Extractor<Message> processorExtractor;
    final SamplerFunction<MessagingRequest> producerSampler;
    final SamplerFunction<MessagingRequest> consumerSampler;
    final String remoteServiceName;
    final Set<String> traceIdProperties;
    @Nullable
    final TraceContext.Extractor jmsProducerExtractor;
    @Nullable
    final TraceContext.Injector jmsProducerInjector;

    public static JmsTracing create(Tracing tracing) {
        return JmsTracing.newBuilder(tracing).build();
    }

    public static JmsTracing create(MessagingTracing messagingTracing) {
        return JmsTracing.newBuilder(messagingTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return JmsTracing.newBuilder(MessagingTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(messagingTracing);
    }

    JmsTracing(Builder builder) {
        this.tracing = builder.messagingTracing.tracing();
        this.tracer = this.tracing.tracer();
        Propagation propagation = builder.messagingTracing.propagation();
        if (JmsTypes.HAS_JMS_PRODUCER) {
            this.jmsProducerExtractor = propagation.extractor(JMSProducerRequest.GETTER);
            this.jmsProducerInjector = propagation.injector(JMSProducerRequest.SETTER);
        } else {
            this.jmsProducerExtractor = null;
            this.jmsProducerInjector = null;
        }
        this.messageProducerExtractor = propagation.extractor(MessageProducerRequest.GETTER);
        this.messageProducerInjector = propagation.injector(MessageProducerRequest.SETTER);
        this.messageConsumerExtractor = propagation.extractor(MessageConsumerRequest.GETTER);
        this.messageConsumerInjector = propagation.injector(MessageConsumerRequest.SETTER);
        this.processorExtractor = propagation.extractor(GETTER);
        this.producerSampler = builder.messagingTracing.producerSampler();
        this.consumerSampler = builder.messagingTracing.consumerSampler();
        this.remoteServiceName = builder.remoteServiceName;
        this.traceIdProperties = new LinkedHashSet<String>(propagation.keys());
    }

    public Connection connection(Connection connection) {
        if (connection instanceof XAConnection) {
            return this.xaConnection((XAConnection)connection);
        }
        return TracingConnection.create(connection, this);
    }

    public QueueConnection queueConnection(QueueConnection connection) {
        if (connection instanceof XAQueueConnection) {
            return this.xaQueueConnection((XAQueueConnection)connection);
        }
        return TracingConnection.create((Connection)connection, this);
    }

    public TopicConnection topicConnection(TopicConnection connection) {
        if (connection instanceof XATopicConnection) {
            return this.xaTopicConnection((XATopicConnection)connection);
        }
        return TracingConnection.create((Connection)connection, this);
    }

    public XAConnection xaConnection(XAConnection xaConnection) {
        return TracingXAConnection.create(xaConnection, this);
    }

    public XAQueueConnection xaQueueConnection(XAQueueConnection connection) {
        return TracingXAConnection.create((XAConnection)connection, this);
    }

    public XATopicConnection xaTopicConnection(XATopicConnection connection) {
        return TracingXAConnection.create((XAConnection)connection, this);
    }

    public ConnectionFactory connectionFactory(ConnectionFactory connectionFactory) {
        if (connectionFactory instanceof XAConnectionFactory) {
            return (ConnectionFactory)this.xaConnectionFactory((XAConnectionFactory)connectionFactory);
        }
        return TracingConnectionFactory.create(connectionFactory, this);
    }

    public XAConnectionFactory xaConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        return TracingXAConnectionFactory.create(xaConnectionFactory, this);
    }

    public MessageListener messageListener(MessageListener messageListener, boolean addConsumerSpan) {
        if (messageListener instanceof TracingMessageListener) {
            return messageListener;
        }
        return new TracingMessageListener(messageListener, this, addConsumerSpan);
    }

    public Span nextSpan(Message message) {
        TraceContextOrSamplingFlags extracted = this.extractAndClearTraceIdProperties(this.processorExtractor, message, message);
        Span result = this.tracer.nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            this.tagQueueOrTopic((MessagingRequest)new MessageConsumerRequest(message, MessageParser.destination(message)), (SpanCustomizer)result);
        }
        return result;
    }

    <R> TraceContextOrSamplingFlags extractAndClearTraceIdProperties(TraceContext.Extractor<R> extractor, R request, Message message) {
        TraceContextOrSamplingFlags extracted = extractor.extract(request);
        PropertyFilter.filterProperties(message, this.traceIdProperties);
        return extracted;
    }

    Span nextMessagingSpan(SamplerFunction<MessagingRequest> sampler, MessagingRequest request, TraceContextOrSamplingFlags extracted) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return this.tracer.nextSpan(extracted);
    }

    void tagQueueOrTopic(MessagingRequest request, SpanCustomizer span) {
        String channelName = request.channelName();
        if (channelName == null) {
            return;
        }
        String channelKind = request.channelKind();
        if ("queue".equals(channelKind)) {
            span.tag(JMS_QUEUE, channelName);
        } else if ("topic".equals(channelKind)) {
            span.tag(JMS_TOPIC, channelName);
        }
    }

    static void log(Throwable thrown, String msg, Object zero, @Nullable Object one) {
        Object[] objectArray;
        Logger logger = LoggerHolder.LOG;
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINE, msg);
        if (one != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = zero;
            objectArray = objectArray2;
            objectArray2[1] = one;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = zero;
        }
        Object[] params = objectArray;
        lr.setParameters(params);
        lr.setThrown(thrown);
        logger.log(lr);
    }

    public static final class Builder {
        final MessagingTracing messagingTracing;
        String remoteServiceName = "jms";

        Builder(MessagingTracing messagingTracing) {
            if (messagingTracing == null) {
                throw new NullPointerException("messagingTracing == null");
            }
            this.messagingTracing = messagingTracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public JmsTracing build() {
            return new JmsTracing(this);
        }
    }

    private static final class JmsTypes {
        static final boolean HAS_JMS_PRODUCER = JmsTypes.hasJMSProducer();

        private JmsTypes() {
        }

        static boolean hasJMSProducer() {
            try {
                Class.forName("jakarta.jms.JMSProducer");
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfFatal((Throwable)t);
                return false;
            }
        }
    }

    private static final class LoggerHolder {
        static final Logger LOG = Logger.getLogger(JmsTracing.class.getName());

        private LoggerHolder() {
        }
    }
}

