/*
 * Decompiled with CFR 0.152.
 */
package brave.jakarta.jms;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import jakarta.jms.CompletionListener;
import jakarta.jms.Message;

final class TracingCompletionListener
implements CompletionListener {
    final CompletionListener delegate;
    final CurrentTraceContext current;
    final Span span;

    static CompletionListener create(CompletionListener delegate, Span span, CurrentTraceContext current) {
        return new TracingCompletionListener(delegate, span, current);
    }

    TracingCompletionListener(CompletionListener delegate, Span span, CurrentTraceContext current) {
        this.delegate = delegate;
        this.span = span;
        this.current = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(Message message) {
        try (CurrentTraceContext.Scope scope = this.current.maybeScope(this.span.context());){
            this.delegate.onCompletion(message);
        }
        finally {
            this.span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Message message, Exception exception) {
        try (CurrentTraceContext.Scope scope = this.current.maybeScope(this.span.context());){
            this.delegate.onException(message, exception);
        }
        finally {
            this.span.error((Throwable)exception);
            this.span.finish();
        }
    }
}

