/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import javax.jms.CompletionListener;
import javax.jms.Message;

final class TracingCompletionListener
implements CompletionListener {
    final Span span;
    final CompletionListener delegate;
    final CurrentTraceContext current;

    static CompletionListener create(CompletionListener delegate, Span span, CurrentTraceContext current) {
        if (span.isNoop()) {
            return delegate;
        }
        return new TracingCompletionListener(delegate, span, current);
    }

    TracingCompletionListener(CompletionListener delegate, Span span, CurrentTraceContext current) {
        this.span = span;
        this.delegate = delegate;
        this.current = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onCompletion(Message message) {
        try {
            CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
            try {
                this.delegate.onCompletion(message);
                if (ws == null) return;
            }
            catch (Throwable throwable) {
                if (ws == null) throw throwable;
                try {
                    ws.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            ws.close();
            return;
        }
        finally {
            this.span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onException(Message message, Exception exception) {
        try {
            CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
            try {
                this.delegate.onException(message, exception);
                if (ws == null) return;
            }
            catch (Throwable throwable) {
                if (ws == null) throw throwable;
                try {
                    ws.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            ws.close();
            return;
        }
        finally {
            this.span.error((Throwable)exception);
            this.span.finish();
        }
    }
}

