/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.jms.JmsTracing;
import brave.jms.TracingSession;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;

final class TracingServerSession
implements ServerSession {
    final ServerSession delegate;
    final JmsTracing jmsTracing;

    static ServerSession create(ServerSession delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("serverSession == null");
        }
        if (delegate instanceof TracingServerSession) {
            return delegate;
        }
        return new TracingServerSession(delegate, jmsTracing);
    }

    TracingServerSession(ServerSession delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
    }

    public Session getSession() throws JMSException {
        return TracingSession.create(this.delegate.getSession(), this.jmsTracing);
    }

    public void start() throws JMSException {
        this.delegate.start();
    }
}

