/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.jms.PropertyFilter;
import brave.jms.TracingConnection;
import brave.jms.TracingConnectionFactory;
import brave.jms.TracingMessageListener;
import brave.jms.TracingXAConnection;
import brave.jms.TracingXAConnectionFactory;
import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;

public final class JmsTracing {
    private static final Logger LOG = Logger.getLogger(JmsTracing.class.getName());
    static final String JMS_QUEUE = "jms.queue";
    static final String JMS_TOPIC = "jms.topic";
    static final Propagation.Getter<Message, String> GETTER = new Propagation.Getter<Message, String>(){

        public String get(Message message, String name) {
            try {
                return message.getStringProperty(name);
            }
            catch (JMSException e) {
                JmsTracing.log(e, "error getting property {0} from message {1}", name, message);
                return null;
            }
        }

        public String toString() {
            return "Message::getStringProperty";
        }
    };
    static final Propagation.Setter<Message, String> SETTER = new Propagation.Setter<Message, String>(){

        public void put(Message message, String name, String value) {
            try {
                message.setStringProperty(name, value);
            }
            catch (JMSException e) {
                JmsTracing.log(e, "error setting property {0} on message {1}", name, message);
            }
        }

        public String toString() {
            return "Message::setStringProperty";
        }
    };
    final Tracing tracing;
    final TraceContext.Extractor<Message> extractor;
    final String remoteServiceName;
    final Set<String> propagationKeys;

    public static JmsTracing create(Tracing tracing) {
        return new Builder(tracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return new Builder(tracing);
    }

    JmsTracing(Builder builder) {
        this.tracing = builder.tracing;
        this.extractor = this.tracing.propagation().extractor(GETTER);
        this.remoteServiceName = builder.remoteServiceName;
        this.propagationKeys = new LinkedHashSet<String>(this.tracing.propagation().keys());
    }

    public Connection connection(Connection connection) {
        if (connection instanceof XAConnection) {
            return this.xaConnection((XAConnection)connection);
        }
        return TracingConnection.create(connection, this);
    }

    public QueueConnection queueConnection(QueueConnection connection) {
        if (connection instanceof XAQueueConnection) {
            return this.xaQueueConnection((XAQueueConnection)connection);
        }
        return TracingConnection.create((Connection)connection, this);
    }

    public TopicConnection topicConnection(TopicConnection connection) {
        if (connection instanceof XATopicConnection) {
            return this.xaTopicConnection((XATopicConnection)connection);
        }
        return TracingConnection.create((Connection)connection, this);
    }

    public XAConnection xaConnection(XAConnection xaConnection) {
        return TracingXAConnection.create(xaConnection, this);
    }

    public XAQueueConnection xaQueueConnection(XAQueueConnection connection) {
        return TracingXAConnection.create((XAConnection)connection, this);
    }

    public XATopicConnection xaTopicConnection(XATopicConnection connection) {
        return TracingXAConnection.create((XAConnection)connection, this);
    }

    public ConnectionFactory connectionFactory(ConnectionFactory connectionFactory) {
        if (connectionFactory instanceof XAConnectionFactory) {
            return (ConnectionFactory)this.xaConnectionFactory((XAConnectionFactory)connectionFactory);
        }
        return TracingConnectionFactory.create(connectionFactory, this);
    }

    public XAConnectionFactory xaConnectionFactory(XAConnectionFactory xaConnectionFactory) {
        return TracingXAConnectionFactory.create(xaConnectionFactory, this);
    }

    public MessageListener messageListener(MessageListener messageListener, boolean addConsumerSpan) {
        if (messageListener instanceof TracingMessageListener) {
            return messageListener;
        }
        return new TracingMessageListener(messageListener, this, addConsumerSpan);
    }

    public Span nextSpan(Message message) {
        TraceContextOrSamplingFlags extracted = this.extractAndClearMessage(message);
        Span result = this.tracing.tracer().nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            this.tagQueueOrTopic(message, (SpanCustomizer)result);
        }
        return result;
    }

    TraceContextOrSamplingFlags extractAndClearMessage(Message message) {
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)message);
        PropertyFilter.filterProperties(message, this.propagationKeys);
        return extracted;
    }

    void setNextParent(Message message, TraceContext context) {
        JmsTracing.addB3SingleHeader(message, context);
    }

    static void addB3SingleHeader(Message message, TraceContext context) {
        SETTER.put((Object)message, (Object)"b3", B3SingleFormat.writeB3SingleFormatWithoutParentId((TraceContext)context));
    }

    @Nullable
    static Destination destination(Message message) {
        try {
            return message.getJMSDestination();
        }
        catch (JMSException e) {
            JmsTracing.log(e, "error destination of message {0}", message, null);
            return null;
        }
    }

    void tagQueueOrTopic(Message message, SpanCustomizer span) {
        Destination destination = JmsTracing.destination(message);
        if (destination != null) {
            this.tagQueueOrTopic(destination, span);
        }
    }

    void tagQueueOrTopic(Destination destination, SpanCustomizer span) {
        try {
            if (destination instanceof Queue) {
                span.tag(JMS_QUEUE, ((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                span.tag(JMS_TOPIC, ((Topic)destination).getTopicName());
            }
        }
        catch (JMSException e) {
            JmsTracing.log(e, "error getting destination name from {0}", destination, null);
        }
    }

    static void log(Throwable thrown, String msg, Object zero, @Nullable Object one) {
        Object[] objectArray;
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINE, msg);
        if (one != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = zero;
            objectArray = objectArray2;
            objectArray2[1] = one;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = zero;
        }
        Object[] params = objectArray;
        lr.setParameters(params);
        lr.setThrown(thrown);
        LOG.log(lr);
    }

    public static final class Builder {
        final Tracing tracing;
        String remoteServiceName = "jms";

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("tracing == null");
            }
            this.tracing = tracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public JmsTracing build() {
            return new JmsTracing(this);
        }
    }
}

